<?php

/*
	WPB Menu And Category Accordion
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 


/**
 * Adding plugin scripts
 */

add_action( 'wp_enqueue_scripts', 'wpb_wmca_adding_scripts', 11 );

function wpb_wmca_adding_scripts() {

	$wpb_wmca_load_cookie 			= wpb_wmca_get_option( 'wpb_wmca_load_cookie', 'other_settings', 'yes' );
	$wpb_wmca_load_font_awesome 	= wpb_wmca_get_option( 'wpb_wmca_load_font_awesome', 'other_settings', 'yes' );


	if( $wpb_wmca_load_cookie && $wpb_wmca_load_cookie == 'yes' ){
		wp_enqueue_script('wpb_wmca_jquery_cookie', plugins_url('assets/js/jquery.cookie.js', __FILE__), array('jquery'), '1.4.1', true);
	}
	wp_enqueue_script('wpb_wmca_accordion_script', plugins_url('assets/js/jquery.navgoco.min.js', __FILE__), array('jquery'), '1.0', true);
	wp_enqueue_script('wpb_wmca_main_script', plugins_url('assets/js/main.js', __FILE__), array('jquery'), '1.0', true);

	wp_localize_script( 'wpb_wmca_main_script', 'wpb_wmca_accordion', array( 
		'accordion_trigger' => apply_filters( 'wpb_wmca_accordion_trigger', 'click' ), // click, mouseenter
	));

	do_action( 'wpb_wmca_add_custom_icons');

	if( $wpb_wmca_load_font_awesome && $wpb_wmca_load_font_awesome == 'yes' ){
		wp_enqueue_style( 'wpb_wmca_font_awesome_style_frontend', plugins_url('admin/assets/css/font-awesome.min.css', __FILE__), '', '1.0' );
	}
	wp_enqueue_style( 'wpb_wmca_accordion_style', plugins_url('assets/css/wpb_wmca_style.css', __FILE__), '', '1.0' );

	wp_add_inline_style( 'wpb_wmca_accordion_style', wpb_wmca_get_all_custom_style() );
}


/**
 * Admin enqueue scripts
 */

function wpb_wmca_adding_admin_scripts() {

	global $pagenow;
	$secreen 			= get_current_screen();
	$cat_icon_support 	= wpb_wmca_get_option( 'wpb_wmca_cat_icon_support','category_accordion' );
	$menu_icon_support 	= wpb_wmca_get_option( 'wpb_wmca_menu_icon_support','menu_accordion' );

	// For Category Page
	if ( $cat_icon_support == 'off' &&  $pagenow == 'edit-tags.php' || $pagenow == 'term.php' ) {
		do_action( 'wpb_wmca_add_custom_icons');
		wp_enqueue_script('wpb_wmca_iconpicker_script', plugins_url('admin/assets/js/icon-picker.min.js', __FILE__), 'jquery', '1.0', true);
		wp_enqueue_style('wpb_wmca_font_awesome_style', plugins_url('admin/assets/css/font-awesome.min.css', __FILE__), '', '1.0');
		wp_enqueue_style('wpb_wmca_iconpicker_style', plugins_url('admin/assets/css/icon-picker.min.css', __FILE__), '', '1.0');
	}

	// For Menu Page
	if ( $menu_icon_support == 'off' &&  $pagenow == 'nav-menus.php' ) {
		do_action( 'wpb_wmca_add_custom_icons');
		wp_enqueue_script('wpb_wmca_iconpicker_script', plugins_url('admin/assets/js/icon-picker.min.js', __FILE__), 'jquery', '1.0', true);
		wp_enqueue_style('wpb_wmca_font_awesome_style', plugins_url('admin/assets/css/font-awesome.min.css', __FILE__), '', '1.0');
		wp_enqueue_style('wpb_wmca_iconpicker_style', plugins_url('admin/assets/css/icon-picker.min.css', __FILE__), '', '1.0');
	}

	if( $secreen->base == 'widgets' ){
		wp_enqueue_script('wpb_wmca_admin_script', plugins_url('admin/assets/js/admin-script.js', __FILE__), 'jquery', '1.0', true);
	}

	// For widget chosen
	wp_enqueue_style('wpb_wmca_wpb_admin_style', plugins_url('admin/assets/css/wpb-admin.css', __FILE__), '', '1.0');

}
add_action( 'admin_enqueue_scripts', 'wpb_wmca_adding_admin_scripts', 11 );


/**
 * Custom CSS
 */

function wpb_wmca_get_all_custom_style(){
	$wpb_wmca_bg_color 				= wpb_wmca_get_option( 'wpb_wmca_bg_color', 'other_settings', '#3b424d' );
	$wpb_wmca_child_bg_color 		= wpb_wmca_get_option( 'wpb_wmca_child_bg_color', 'other_settings', '#383838' );
	$wpb_wmca_text_color 			= wpb_wmca_get_option( 'wpb_wmca_text_color', 'other_settings', '#f5f5f5' );
	$wpb_wmca_border_color 			= wpb_wmca_get_option( 'wpb_wmca_border_color', 'other_settings', '#414956' );
	$wpb_wmca_bg_hover_color 		= wpb_wmca_get_option( 'wpb_wmca_bg_hover_color', 'other_settings', '#383F4A' );
	$primary_color 					= wpb_wmca_get_option( 'wpb_wmca_primary_color', 'wpb_wamc_style_settings', '#d63031' );
	$primary_color_dark 			= wpb_wmca_get_option( 'wpb_wmca_primary_color_dark', 'wpb_wamc_style_settings', '#c30000' );
	$wpb_wmca_indicator_open_rotate = wpb_wmca_get_option( 'wpb_wmca_indicator_open_rotate', 'other_settings', '45' );

	$wpb_wmca_child_bg_hover_color 	= wpb_wmca_get_option( 'wpb_wmca_child_bg_hover_color', 'other_settings', '#383838' );
	$wpb_wmca_text_color_hover 		= wpb_wmca_get_option( 'wpb_wmca_text_color_hover', 'other_settings', '#f5f5f5' );
	$wpb_wmca_border_color_hover 	= wpb_wmca_get_option( 'wpb_wmca_border_color_hover', 'other_settings', '#414956' );

	$wpb_wmca_current_border_color 	= wpb_wmca_get_option( 'wpb_wmca_current_border_color', 'other_settings', '' );
	$wpb_wmca_current_color 		= wpb_wmca_get_option( 'wpb_wmca_current_color', 'other_settings', '' );
	$wpb_wmca_current_bg_color 		= wpb_wmca_get_option( 'wpb_wmca_current_bg_color', 'other_settings', '' );

	$custom_css = '';
	ob_start();
	?>
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul li > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul ul li > a {
		  border-bottom: 1px solid <?php echo $wpb_wmca_border_color; ?>!important;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a:visited{
		  color: <?php echo $wpb_wmca_text_color; ?>!important;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li li:hover > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom li.wpb-submenu-indicator-minus > a {
		  border-left-color: <?php echo $wpb_wmca_border_color; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a {
		  background: <?php echo $wpb_wmca_bg_color; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom ul > li li {
		  background: <?php echo $wpb_wmca_child_bg_color; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a:hover {
		  background-color: <?php echo $wpb_wmca_bg_hover_color; ?>;
		}

		.wpb_category_n_menu_accordion li.wpb-submenu-indicator-minus > a > span.wpb-submenu-indicator i {
			-ms-transform: rotate(<?php echo $wpb_wmca_indicator_open_rotate; ?>deg);
			-moz-transform: rotate(<?php echo $wpb_wmca_indicator_open_rotate; ?>deg);
			-webkit-transform: rotate(<?php echo $wpb_wmca_indicator_open_rotate; ?>deg);
			transform: rotate(<?php echo $wpb_wmca_indicator_open_rotate; ?>deg);
		}

		.wpb_category_n_menu_accordion.wpb_wmca_theme_minimal li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_minimal li.current-menu-item > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design li.current-menu-item > a {
			color: <?php echo $primary_color; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design > ul > li > a {
		  background-color: <?php echo $primary_color; ?>;
		  border-color: <?php echo $primary_color_dark; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design li.current-menu-item > a {
			color: <?php echo $primary_color_dark; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_flat_design > ul > li > a:hover {
			background-color: <?php echo $primary_color_dark; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom ul > li li > a:hover {
			background-color: <?php echo $wpb_wmca_child_bg_hover_color; ?>;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a:hover {
			color: <?php echo $wpb_wmca_text_color_hover; ?>!important;
		}

		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a:hover,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul li > a:hover,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul ul li > a:hover {
		  border-bottom: 1px solid <?php echo $wpb_wmca_border_color_hover; ?>!important;
		}
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li li:hover > a:hover,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom li.wpb-submenu-indicator-minus > a:hover {
		  border-left-color: <?php echo $wpb_wmca_border_color_hover; ?>;
		}

		<?php if( $wpb_wmca_current_bg_color ||  $wpb_wmca_current_color): ?>
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a {
			background-color: <?php echo $wpb_wmca_current_bg_color; ?>!important;
			color: <?php echo $wpb_wmca_current_color; ?>!important;
		}
		<?php endif; ?>
		<?php if( $wpb_wmca_current_border_color): ?>
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a {
			border-bottom: 1px solid <?php echo $wpb_wmca_current_border_color; ?>!important;
		}
		<?php endif; ?>
		<?php if( $wpb_wmca_current_border_color): ?>
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a,
		.wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a {
			border-left-color: <?php echo $wpb_wmca_current_border_color; ?>!important;
		}
		<?php endif; ?>

	<?php

	return ob_get_clean();
}


/**
 *  Adding the Themify icons 
 */

add_action( 'init', 'wpb_wmca_check_themify_icons' );
function wpb_wmca_check_themify_icons(){
	$wpb_wmca_load_themify_icons 	= wpb_wmca_get_option( 'wpb_wmca_load_themify_icons', 'other_settings', 'yes' );

	if( $wpb_wmca_load_themify_icons == 'yes' ){
		add_action( 'wpb_wmca_add_custom_icons', 'wpb_wmca_add_themify_icons' );
		add_action( 'wpb_wmca_icon_set', 'wpb_wmca_add_themify_icons_list' );
		add_action( 'wpb_wmca_icon_set_init', 'wpb_wmca_themify_icon_set_init' );
	}
}


/**
 * Load Themify icons
 */

function wpb_wmca_add_themify_icons(){
	wp_enqueue_style( 'wpb_wmca_themify_icons', plugins_url('admin/assets/css/themify-icons.css', __FILE__), '', '1.0' );
}

/**
 * Themify icons List
 */

function wpb_wmca_add_themify_icons_list(){
	$icons         = [];
	$themify_icons = file(WPB_WAMC_PATH . 'admin/assets/css/themify-icons.css');

	if( !empty($themify_icons) ){
		foreach($themify_icons as $themify_icon) {
			if(stripos($themify_icon, ".ti-") === 0) {
				$l = explode(":", $themify_icon);
		    	$icons[str_replace(".", "", $l[0])] = str_replace(".", "", $l[0]);
			}
		}
	}

	if( !empty($icons) ){	
		?>
			<div class="ti-set icon-set">
				<?php 
					if( function_exists('wpb_wmca_icons_search_box') ){
						wpb_wmca_icons_search_box();
					}
				?>
				<ul class="wpb_wmca_icons_list">
					<?php 
						foreach ($icons as $icon ) {
							printf('<li  data-class="%s" class="%s"></li>', esc_attr( $icon ), esc_attr( $icon ));
						}
					?>
				</ul>
			</div>
		<?php
	}
}

/**
 * Themify icons Init
 */

function wpb_wmca_themify_icon_set_init(){
	echo "'ti' : 'Themify Icons',";
}