<?php
/**
 * Plugin Name:       WPB Accordion Menu or Category PRO
 * Plugin URI:        https://wpbean.com/downloads/wpb-accordion-menu-category-pro/
 * Description:       WPB Accordion Menu or Category Plugin allow you to show WordPress menu or any category accordion with submenu / subcategory support. Specially optimized for WooCommerce or any other ecommerce categories. It's responsive and modern flat design.
 * Version:           2.0
 * Author:            wpbean
 * Author URI:        https://wpbean.com/
 * Text Domain:       wpb-accordion-menu-or-category
 * Domain Path:       /languages
 *
 * WC requires at least: 4.0
 * WC tested up to: 4.5.2
 */

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'is_plugin_active' ) ) {
    require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}

/**
 * Define 
 */

if ( ! defined( 'WPB_WAMC_FILE' ) ) {
	define( "WPB_WAMC_FILE", __FILE__ );
}

if ( ! defined( 'WPB_WAMC_PATH' ) ) {
	define( "WPB_WAMC_PATH", plugin_dir_path( WPB_WAMC_FILE ) );
}

if ( ! defined( 'WPB_WAMC_PREMIUM' ) ) {
    define( 'WPB_WAMC_PREMIUM', plugin_basename( __FILE__ ) );
}

if ( !defined( 'WPB_WAMC_Plugin_Path' ) ) {
    define( 'WPB_WAMC_Plugin_Path', trailingslashit( plugin_dir_path( __FILE__ ) ) );
}

if ( !defined( 'WPB_WAMC_Plugin_EL_Template_Path' ) ) {
    define( 'WPB_WAMC_Plugin_EL_Template_Path', WPB_WAMC_Plugin_Path . '/elementor/' );
}


/**
 * Free version deactivation if installed
 */

if( ! function_exists( 'wpbean_deactive_free_version' ) ) {
    require_once 'inc/wpb-deactive-plugin.php';
}
wpbean_deactive_free_version( 'WPB_WAMC_FREE_INIT', plugin_basename( __FILE__ ) );


/**
 * Plugin Init
 */

function wpb_wmca_pro_plugin_init(){
	load_plugin_textdomain( 'wpb-accordion-menu-or-category', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
	add_action( 'admin_init', 'wpb_wamc_plugin_updater_init', 0 );
	add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'wpb_wmca_pro_plugin_actions' );
	wpb_wmca_pro_load_plugin_files();
}
add_action( 'plugins_loaded', 'wpb_wmca_pro_plugin_init' );


/**
 * WpBean Plugin updater init
 * Warning!!!! 
 * Do not make any change in the code bellow. It will process the plugin auto update.
 */

define( 'WPB_WAMC_VERSION', '2.0' );
define( 'WPB_WAMC_ITEM_ID', 2607 ); 

function wpb_wamc_plugin_updater_init() {
	$updater_init 	= wpb_wamc_updater_init();
	$store_url 		= $updater_init->store_url;
	$prefix 		= $updater_init->prefix;
	$license_key 	= trim( wpb_wmca_get_option( $updater_init->prefix.'license_key', $updater_init->license_page_slug ) );

	$edd_updater = new WPB_EDD_SL_Plugin_Updater( $store_url, __FILE__, array(
		'version'   => WPB_WAMC_VERSION,
		'license'   => $license_key,
		'item_id'   => WPB_WAMC_ITEM_ID,
		'author'    => 'WpBean',
		'url'       => home_url()
	));
}


/**
 * Add plugin action links
 */

function wpb_wmca_pro_plugin_actions( $links ) {

	$links[] = '<a href="'. esc_url( admin_url('/options-general.php?page=wpb_wcma_settings', false) ) .'">'. esc_html__('Settings', 'wpb-accordion-menu-or-category') .'</a>';
	$links[] = '<a href="https://wpbean.com/support/" target="_blank">'. esc_html__('Support', 'wpb-accordion-menu-or-category') .'</a>';
	$links[] = '<a href="https://www.youtube.com/watch?v=K3sjZeHHbK4" target="_blank">'. esc_html__('Documentation', 'wpb-accordion-menu-or-category') .'</a>';
	
	return $links;
}


/**
 * Required files
 */

function wpb_wmca_pro_load_plugin_files(){
	require_once dirname( __FILE__ ) . '/wpb-scripts.php';
	require_once dirname( __FILE__ ) . '/inc/wpb-wmca-functions.php';
	require_once dirname( __FILE__ ) . '/inc/wpb-wmca-shortcodes.php';
	require_once dirname( __FILE__ ) . '/admin/wpb-wmca-taxonomie-meta.php';
	require_once dirname( __FILE__ ) . '/admin/wpb-wmca-widget.php';
	require_once dirname( __FILE__ ) . '/admin/settings/class.settings-api.php';
	require_once dirname( __FILE__ ) . '/admin/settings/wpb-wmca-settings.php';
	require_once dirname( __FILE__ ) . '/admin/settings/wpb-wmca-options-config.php';
	require_once dirname( __FILE__ ) . '/admin/wp-menu-item-custom-fields/menu-item-custom-fields-config.php';
	if( defined('ELEMENTOR__FILE__') ){
        require_once dirname( __FILE__ ) . '/inc/wpb-wmca-elementor.php';
    }
	if( !class_exists( 'WPB_EDD_SL_Plugin_Updater' ) ) {
		include( dirname( __FILE__ ) . '/admin/updater/plugin-updater.php' );
	}
	require_once dirname( __FILE__ ) . '/admin/updater/updater-init.php';
}