<?php

/*
	WPB Menu & Category Accordion
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 



/* ==========================================================================
   WPB Category Accordion Shortcode
   ========================================================================== */


if ( !function_exists('wpb_wmca_category_shortcode_function') ):

	function wpb_wmca_category_shortcode_function($atts){
		extract(shortcode_atts(array(
			'taxonomy' 		=> 'category',
			'orderby' 		=> 'name',
			'order' 		=> 'ASC',
			'show_count' 	=> 'no', // yes
			'hide_empty' 	=> 'yes', // no
			'exclude' 		=> '', // excludes the category with the ID
			'include' 		=> '', // include the category with the ID
			'hierarchical' 	=> 'no', //  Display sub-categories as inner list items (below the parent list item) or inline.
			'number' 		=> 0, //  Sets the number of Categories to display. This causes the SQL LIMIT value to be defined. Default to no LIMIT.
			'depth' 		=> 0, //  This parameter controls how many levels in the hierarchy of Categories are to be included in the list of Categories.
			'accordion' 	=> 'yes', // Close previously opened accordion
			'xclass' 		=> '', // Extra Class
			'theme' 		=> wpb_wmca_get_option( 'wpb_wmca_theme', 'other_settings', 'dark' ),
			'show_icon' 	=> 'yes',
			'only_child' 	=> 'no',
			'only_top_cats_with_posts' 	=> 'no',
			'show_posts' 	=> 'no',
			'post_type' 	=> 'post',
			'numberposts' 	=> 3,
		), $atts));

		$cat_parent_open 		= wpb_wmca_get_option( 'wpb_wmca_cat_parent_open', 'category_accordion' );
		$current_cat_open 		= wpb_wmca_get_option( 'wpb_wmca_current_cat_open', 'category_accordion' );
		$indicator_icon 		= wpb_wmca_get_option( 'wpb_wmca_sub_menu_indicator_icon', 'other_settings', 'fa fa-plus' );
		$wpb_wmca_cat_icon_type = wpb_wmca_get_option( 'wpb_wmca_cat_icon_type', 'category_accordion' );
		$show_desc_for_title    = wpb_wmca_get_option( 'wpb_wmca_show_desc_for_title', 'category_accordion' );

		if( !isset( $theme ) ){
			$theme = 'dark';
		}

		if( isset($_GET['skin']) ) {
			$theme = $_GET['skin'];
		}

		$container_classes = array(
			'wpb_category_n_menu_accordion',
			'wpb_wmca_theme_' .  $theme,
			'wpb_wcma_cat_parent_open_' .  $cat_parent_open,
			'wpb_wmca_current_cat_open_' .  $current_cat_open,
			'wpb_wmca_show_posts_' .  $show_posts,
			'wpb_wmca_post_type_' .  $post_type,
			'wpb_wmca_taxonomy_' .  $taxonomy,
			'wpb_wmca_icon_type_' .  $wpb_wmca_cat_icon_type,
		);

		if( $xclass ){
			$container_classes[] = $xclass;
		}

		$current_cat 	= '';
		$cat_ancestors 	= array();

		global $wp_query, $post;

		if( is_singular( 'product' ) && function_exists('wc_get_product_terms') ){

			$terms = wc_get_product_terms(
				$post->ID, 'product_cat', apply_filters(
					'woocommerce_product_categories_widget_product_terms_args', array(
						'orderby' => 'parent',
						'order'   => 'DESC',
					)
				)
			);

			if ( $terms ) {
				$main_term           = apply_filters( 'woocommerce_product_categories_widget_main_term', $terms[0], $terms );
				$current_cat   	     = $main_term;
				$cat_ancestors 		 = get_ancestors( $main_term->term_id, 'product_cat' );
			}
		}


		ob_start();
		?>

		<div class="<?php echo esc_attr( implode(' ', $container_classes) ); ?>" data-accordion="<?php echo esc_attr( $accordion == 'yes' ? 'true' : 'false' ) ; ?>" data-indicator_icon="<?php echo esc_attr( $indicator_icon ) ; ?>">
			<ul class="wpb_category_n_menu_accordion_list">
				<?php

					$walker_args = array(
						'show_posts'					=> $show_posts,
						'post_type'						=> $post_type,
						'taxonomy'						=> $taxonomy,
						'numberposts'					=> $numberposts,
						'only_top_cats_with_posts'		=> $only_top_cats_with_posts,
					);

				    $args = apply_filters( 'wpb_wcma_wp_list_categories_args', array(
						'show_option_all'   			=> '',
						'orderby'            			=> $orderby,
						'order'              			=> $order,
						'style'              			=> 'list',
						'show_count'         			=> ( $show_count == 'yes' ? 1 : 0 ),
						'hide_empty'         			=> ( $hide_empty == 'yes' ? 1 : 0 ),
						'exclude'            			=> $exclude,
						'exclude_tree'       			=> '',
						'include'            			=> $include,
						'hierarchical'       			=> ( ($hierarchical == 'no' || $hierarchical == '') ? 1 : 0 ),
						'title_li'           			=> '',
						'number'             			=> ( $number == 0 ? null : $number ),
						'echo'               			=> 1,
						'depth'              			=> $depth,
						'taxonomy'           			=> $taxonomy,
						'accordion_theme'    			=> $theme,
						'use_desc_for_title'    		=> ( $show_desc_for_title == 'on' ? 1 : 0 ),
						'show_cat_icon'      			=> $show_icon,
						'current_category'   			=> ( $current_cat ? $current_cat->term_id : '' ),
						'current_category_ancestors'   	=> ( $cat_ancestors ? $cat_ancestors : '' ),
						'parent' 						=> ( $only_top_cats_with_posts == 'yes' ? 0 : '' ),
						'walker'             			=> new WPB_WCMA_Category_Walker($walker_args),
				    ));

				    /* Show only child categories of active category */

				    if( $only_child == 'yes' && is_tax($taxonomy) ){

				    	$current_cat_object = get_queried_object();

				    	if( $current_cat_object ){
				    		$current_cat_id 	= $current_cat_object->term_id;
				    		$args['child_of'] 	= $current_cat_id;
				    	}
				    }

				    wp_list_categories( $args );
				?>
			</ul>
		</div>

		<?php
		return ob_get_clean();
	}

	add_shortcode( 'wpb_category_accordion', 'wpb_wmca_category_shortcode_function' );

endif;	




/* ==========================================================================
   WPB Menu Accordion Shortcode
   ========================================================================== */


if ( !function_exists('wpb_wmca_menu_shortcode_function') ):

	function wpb_wmca_menu_shortcode_function($atts){
		extract(shortcode_atts(array(
			'theme_location' 	=> '', // menu theme location
			'menu' 				=> '', // (optional) The menu that is desired; accepts (matching in order) id, slug, name
			'accordion' 		=> 'yes', // Close previously opened accordion
			'depth' 			=> 0, 
			'xclass' 			=> '', // Extra Class
			'jc_submenu' 		=> 'no', // Add support of JC Submenu
			'theme' 			=> wpb_wmca_get_option( 'wpb_wmca_theme', 'other_settings', 'dark' ),
		), $atts));

		$menu_parent_open 			= wpb_wmca_get_option( 'wpb_wmca_menu_parent_open', 'menu_accordion' );
		$current_menu_open 			= wpb_wmca_get_option( 'wpb_wmca_current_menu_open', 'menu_accordion' );
		$indicator_icon 			= wpb_wmca_get_option( 'wpb_wmca_sub_menu_indicator_icon', 'other_settings', 'fa fa-plus' );

		if( !isset( $theme ) ){
			$theme = 'dark';
		}

		if( isset($_GET['skin']) ) {
			$theme = $_GET['skin'];
		}

		$container_classes = array(
			'wpb_category_n_menu_accordion',
			'wpb_wmca_theme_' .  $theme,
			'wpb_wcma_manu_parent_open_' .  $menu_parent_open,
			'wpb_wmca_current_menu_open_' .  $current_menu_open,
		);

		if( $xclass ){
			$container_classes[] = $xclass;
		}

		ob_start();
		?>

		<div class="<?php echo esc_attr( implode(' ', $container_classes) ); ?>" data-accordion="<?php echo esc_attr( $accordion == 'yes' ? 'true' : 'false' ) ; ?>" data-indicator_icon="<?php echo esc_attr( $indicator_icon ) ; ?>">
			<?php
				$default_options = array(
					'theme_location'  => $theme_location,
					'menu'            => $menu,
					'container'       => '',
					'container_class' => '',
					'container_id'    => '',
					'menu_class'      => 'wpb_category_n_menu_accordion_list',
					'menu_id'         => '',
					'echo'            => true,
					'before'          => '',
					'after'           => '',
					'link_before'     => '',
					'link_after'      => '',
					'items_wrap'      => '<ul id="%1$s" class="%2$s">%3$s</ul>',
					'depth'           => $depth,
					'walker'          => new WPB_WMCA_Nav_Walker,
				);

				if( $jc_submenu == 'yes' ){
					$default_options['walker'] = '';
				}

				$options = apply_filters( 'wpb_wcma_wp_nav_menu_args', $default_options );

				wp_nav_menu( $options );
			?>
		</div>
		<?php
		return ob_get_clean();
	}

	add_shortcode( 'wpb_menu_accordion', 'wpb_wmca_menu_shortcode_function' );

endif;