<?php

/*
	WPB Menu & Category Accordion
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 



/**
 * Text Widget Shortcode Support
 */

add_filter('widget_text', 'do_shortcode');


/**
 * Accordion skins
 */

function wpb_wmca_accordion_skins(){

    $skins = apply_filters( 'wpb_wmca_accordion_skins', array(
        'dark'              => esc_html__( 'Dark', 'wpb-accordion-menu-or-category' ),
        'transparent'       => esc_html__( 'Transparent', 'wpb-accordion-menu-or-category' ),
        'minimal'           => esc_html__( 'Minimal', 'wpb-accordion-menu-or-category' ),
        'flat_design'       => esc_html__( 'Flat Design', 'wpb-accordion-menu-or-category' ),
        'material_design'   => esc_html__( 'Material Design', 'wpb-accordion-menu-or-category' ),
        'custom'            => esc_html__( 'Custom Skin', 'wpb-accordion-menu-or-category' ),
    ));

    return $skins;
}



/**
 * WPB WMCA Category Walker
 */


class WPB_WCMA_Category_Walker extends Walker_Category {


    private $walker_args;

    public function __construct( $walker_args = array() ) {
        $this->walker_args = $walker_args;
    }

    /**
     * Starts the list before the elements are added.
     *
     * Added for Flatsome theme issue fix
     */
    public function start_lvl( &$output, $depth = 0, $args = array() ) {
        if ( 'list' != $args['style'] )
            return;
 
        $indent = str_repeat("\t", $depth);
        $output .= "$indent<ul class='wpb-wcma-children wpb-wcma-children-cats'>\n";
    }

	public function start_el( &$output, $category, $depth = 0, $args = array(), $id = 0 ) {

		/** This filter is documented in wp-includes/category-template.php */
		$cat_name = apply_filters(
			'list_cats',
			esc_attr( $category->name ),
			$category
		);

		// Don't generate an element if the category name is empty.
		if ( ! $cat_name ) {
			return;
		}

		$wpb_wmca_cat_count   = '';
        $wpb_wmca_cat_icon    = '';
		$show_cat_icon        = $args['show_cat_icon'];

        if( $args['accordion_theme'] == 'minimal' ){
            $show_cat_icon = 'no';
        }


        $wpb_wmca_cat_icon_type = wpb_wmca_get_option( 'wpb_wmca_cat_icon_type', 'category_accordion' );

		// Getting the category icon [ texonomoy meta ]
		$wpb_wcma_term_meta = get_option( "taxonomy_$category->term_id" );

		if ( ! empty( $wpb_wcma_term_meta['wpb_wcma_cat_icons'] ) && $show_cat_icon == 'yes' && $wpb_wmca_cat_icon_type == 'font' ) {
			$wpb_wmca_cat_icon = '<i class="'.$wpb_wcma_term_meta['wpb_wcma_cat_icons'].'"></i>';
		}

        // cat image
        $product_cat_png_icon_id    = absint( get_term_meta( $category->term_id, 'product_cat_png_icon_id', true ) );
        if ( $product_cat_png_icon_id && $show_cat_icon == 'yes' && $wpb_wmca_cat_icon_type == 'png' ) {
            $wpb_wmca_cat_icon = '<img src="'.esc_url( wp_get_attachment_thumb_url( $product_cat_png_icon_id ) ).'" height="48" width="48">';
        }

		// Adding Post count 
		if ( ! empty( $args['show_count'] ) ) {
			$wpb_wmca_cat_count = '<span class="wpb-wmca-cat-count"><span>' . number_format_i18n( $category->count ) . '</span></span>';
		}

        // If has cat child
        $open_accordion_on_cat_click = wpb_wmca_get_option( 'wpb_wmca_open_accordion_on_cat_click', 'category_accordion' );

        if( $args['has_children'] == true && $open_accordion_on_cat_click == 'on' ){
            $link = '<a href="#" ';
        }else{
            $link = '<a href="' . esc_url( get_term_link( $category ) ) . '" ';
        }

		
		if ( $args['use_desc_for_title'] && ! empty( $category->description ) ) {
			$link .= 'title="' . esc_attr( strip_tags( apply_filters( 'category_description', $category->description, $category ) ) ) . '"';
		}

		$link .= '>'.$wpb_wmca_cat_icon;
		$link .= $cat_name . $wpb_wmca_cat_count. '</a>';



		if ( 'list' == $args['style'] ) {
			$output .= "\t<li";
			$css_classes = array(
				'cat-item',
				'cat-item-' . $category->term_id,
			);

			$termchildren = get_term_children( $category->term_id, $category->taxonomy );

            if( count($termchildren)>0 ){
                $css_classes[] =  'cat-item-have-child';
            }
            if( $category->count>0 ){
                $css_classes[] =  'wpb-wmca-cat-item-have-posts';
            }


            if( is_singular( 'product' ) ){
                if ( ! empty( $args['current_category'] ) ) {
                    if ( $args['current_category'] === $category->term_id ) {
                        $css_classes[] = 'current-cat';
                    }
                }

                if ( $args['has_children'] && $args['hierarchical'] && ( empty( $args['max_depth'] ) || $args['max_depth'] > $depth + 1 ) ) {
                    //$css_classes[] = 'current-cat';
                }

                if ( $args['current_category_ancestors'] && $args['current_category'] && in_array( $category->term_id, $args['current_category_ancestors'], true ) ) {
                    $css_classes[] = 'wpb-wmca-current-cat-parent';
                }
            }else{
                if ( ! empty( $args['current_category'] ) ) {
                    $_current_category = get_term( $args['current_category'], $category->taxonomy );
                    if ( $category->term_id == $args['current_category'] ) {
                        $css_classes[] = 'current-cat';
                    } elseif ( $category->term_id == $_current_category->parent ) {
                        $css_classes[] = 'wpb-wmca-current-cat-parent';
                    }
                }
            }

			$css_classes = implode( ' ', apply_filters( 'wpb_wmca_category_css_class', $css_classes, $category, $depth, $args ) );

			$output .=  ' class="' . $css_classes . '"';
			$output .= ">$link\n";
		} else {
			$output .= "\t$link<br />\n";
		}

	}

    /**
     *  Adding Posts to the category list
     */

    public function end_el( &$output, $page, $depth = 0, $args = array() ) {
        if ( 'list' != $args['style'] ) {
            return;
        }

        $walker_args = $this->walker_args;


        if( $walker_args['only_top_cats_with_posts'] == 'yes' ){
            if( count( get_term_children( $page->term_id, $walker_args['taxonomy'] ) ) != 0 ){
                $term_id = get_term_children( $page->term_id, $walker_args['taxonomy'] );
            }else{
                $term_id = $page->term_id;
            }
        }else{
            $term_id = $page->term_id;
        }

        $posts = get_posts( array(
            'numberposts'   => $walker_args['numberposts'],
            'post_type'     => $walker_args['post_type'],
            'tax_query'     => array(
                array(
                  'taxonomy'            => $walker_args['taxonomy'],
                  'field'               => 'term_id',
                  'terms'               => $term_id,
                  'include_children'    => false,
                )
            )
        ) );

        $posts_list = '';
        global $post,$wp_query;
        $current_id = $wp_query->get_queried_object_id();

        if( !empty( $posts ) && $walker_args['show_posts'] == 'yes' ) {

            if( $walker_args['only_top_cats_with_posts'] == 'no' ){ 
                $posts_list .= '<ul class="wpb-wcma-children wpb-wcma-children-posts">';
            }else{
                $posts_list .= '<ul class="wpb-wcma-children wpb-wcma-children-cats">';
            }

            foreach( $posts as $post ){
                if( $current_id == $post->ID ){
                    $x_class = ' wpb-wcma-current-post';
                }else{
                    $x_class = '';
                }
                $posts_list .= '<li class="wpb-wcma-post-item wpb-wcma-post-item-'. esc_attr( $post->ID ) . $x_class .'"><a href="' . esc_url( get_permalink( $post->ID ) ) . '">'. esc_html( get_the_title( $post->ID ) ) .'</a></li>';
            }

            $posts_list .= '</ul>';
        }
        else {
            $posts_list = '';
        }

        $output .= "{$posts_list}</li>\n";
    }
}




/**
 * WPB WMCA NAV Walker
 */


/**
 * Create HTML list of nav menu items.
 * Replacement for the native Walker, using the description.
 */
class WPB_WMCA_Nav_Walker extends Walker_Nav_Menu {
    /**
     * Start the element output.
     *
     * @param  string $output Passed by reference. Used to append additional content.
     * @param  object $item   Menu item data object.
     * @param  int $depth     Depth of menu item. May be used for padding.
     * @param  array $args    Additional strings.
     * @return void
     */
    function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ){

        $classes     = empty ( $item->classes ) ? array () : (array) $item->classes;

        /* remove default has-children class */
        if (($key = array_search('menu-item-has-children', $classes)) !== false) {
            unset($classes[$key]);
        }

        $class_names = join(
            ' '
        ,   apply_filters(
                'nav_menu_css_class'
            ,   array_filter( $classes ), $item
            )
        );


        if($args->has_children) { $class_names .= ' wpb-wmca-menu-item-has-children'; }

        $wpb_wmca_menu_item_keep_open = get_post_meta( $item->ID, 'menu-item-keep-open', true );
        $menu_item_keep_open = ( $wpb_wmca_menu_item_keep_open == 'yes' ? ' wpb_wmca_menu_item_keep_open' : '' );


        ! empty ( $class_names )

            and $class_names = ' class="'. esc_attr( $class_names ) . esc_attr( $menu_item_keep_open ) .'"';

        $output .= "<li id='menu-item-$item->ID' $class_names>";

        $attributes  = '';

        ! empty( $item->attr_title )
            and $attributes .= ' title="'  . esc_attr( $item->attr_title ) .'"';
        ! empty( $item->target )
            and $attributes .= ' target="' . esc_attr( $item->target     ) .'"';
        ! empty( $item->xfn )
            and $attributes .= ' rel="'    . esc_attr( $item->xfn        ) .'"';

        $open_accordion_on_menu_click = wpb_wmca_get_option( 'wpb_wmca_open_accordion_on_menu_click','menu_accordion' );

        if ( $args->has_children && $open_accordion_on_menu_click == 'on' ){
            $attributes .= ' href="#"';
        }elseif( ! empty( $item->url ) ){
            $attributes .= ' href="'   . esc_attr( $item->url        ) .'"';
        }

        // insert description for top level elements only
        // you may change this
        $wpb_wmca_menu_icon = get_post_meta( $item->ID, 'menu-item-icon', true );
        $wpb_wmca_menu_icon_support = wpb_wmca_get_option( 'wpb_wmca_menu_icon_support','menu_accordion' );
        $wpb_wmca_menu_icon_setup = ( ! empty ( $wpb_wmca_menu_icon ) && $wpb_wmca_menu_icon_support == 'off' )
            ? '<i class="'.esc_attr( $wpb_wmca_menu_icon ).'"></i>' : ''; 

        $title = apply_filters( 'the_title', $item->title, $item->ID );

        $item_output = $args->before
            . "<a $attributes>"
            . $wpb_wmca_menu_icon_setup
            . $args->link_before
            . $title
            . '</a> '
            . $args->link_after
            . $args->after;

        // Since $output is called by reference we don't need to return anything.
        $output .= apply_filters(
            'walker_nav_menu_start_el'
        ,   $item_output
        ,   $item
        ,   $depth
        ,   $args
        );
    }


    public function display_element( $element, &$children_elements, $max_depth, $depth, $args, &$output ) {
        if ( ! $element )
            return;

        $id_field = $this->db_fields['id'];

        // Display this element.
        if ( is_object( $args[0] ) )
           $args[0]->has_children = ! empty( $children_elements[ $element->$id_field ] );

        parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
    }
}


/**
 * Get the placeholder image URL either from media, or use the fallback image.
 * @return string
 */
function wpb_wmca_placeholder_img_src() {
    $src = plugins_url('../assets/images/placeholder.png', __FILE__);
    return apply_filters( 'wpb_wmca_placeholder_img_src', $src );
}