<?php


/**
 * Add a New Elementor Widegt Category
 */

add_action( 'elementor/init', 'wpb_wmca_add_elementor_category' );

if( !function_exists('wpb_wmca_add_elementor_category') ){
    function wpb_wmca_add_elementor_category(){
        \Elementor\Plugin::instance()->elements_manager->add_category(
            'wpb_widgets',
            array(
                'title' => esc_html__( 'WpBean Plugins', 'wpb-accordion-menu-or-category' ),
            ),
            1
        );
    }
}


/**
 * Add Elementor Widegts
 */


class WPB_FP_Elementor_Element {

  private static $instance = null;

  public static function get_instance() {
    if ( ! self::$instance )
    self::$instance = new self;
    return self::$instance;
  }

  public function init(){
    add_action( 'elementor/widgets/widgets_registered', array( $this, 'widgets_registered' ) );
    add_action( 'elementor/frontend/after_register_scripts', array( $this, 'widget_register_scripts' ) );
    add_action( 'elementor/frontend/after_enqueue_scripts', array( $this, 'widget_enqueue_scripts' ) );
    add_action( 'elementor/editor/after_enqueue_scripts', array( $this, 'widget_enqueue_scripts' ) );
    add_action( 'elementor/frontend/after_register_styles', array( $this, 'widget_register_styles' ) );
    add_action( 'elementor/frontend/after_enqueue_styles', array($this, 'widget_enqueue_styles') );

  }

  public function widget_register_scripts() {
    $wpb_wmca_load_cookie = wpb_wmca_get_option( 'wpb_wmca_load_cookie', 'other_settings', 'yes' );

    if( $wpb_wmca_load_cookie && $wpb_wmca_load_cookie == 'yes' ){
      wp_register_script('wpb_wmca_jquery_cookie', plugins_url('../assets/js/jquery.cookie.js', __FILE__), array('jquery'), '1.4.1', true);
    }
    wp_register_script('wpb_wmca_accordion_script', plugins_url('../assets/js/jquery.navgoco.min.js', __FILE__), array('jquery'), '1.0', true);
    wp_register_script('wpb_wmca_main_script', plugins_url('../assets/js/main.js', __FILE__), array('jquery'), '1.0', true);
    wp_register_script('wpb_wmca_el_main_script', plugins_url('../assets/js/el-main.js', __FILE__), array('jquery'), '1.0', true);
  }

  public function widget_enqueue_scripts() {
    $wpb_wmca_load_cookie = wpb_wmca_get_option( 'wpb_wmca_load_cookie', 'other_settings', 'yes' );

    if( $wpb_wmca_load_cookie && $wpb_wmca_load_cookie == 'yes' ){
      wp_enqueue_script('wpb_wmca_jquery_cookie', plugins_url('../assets/js/jquery.cookie.js', __FILE__), array('jquery'), '1.4.1', true);
    }
    wp_enqueue_script('wpb_wmca_accordion_script', plugins_url('../assets/js/jquery.navgoco.min.js', __FILE__), array('jquery'), '1.0', true);
    wp_enqueue_script('wpb_wmca_main_script', plugins_url('../assets/js/main.js', __FILE__), array('jquery'), '1.0', true);
    wp_enqueue_script('wpb_wmca_el_main_script', plugins_url('../assets/js/el-main.js', __FILE__), array('jquery'), '1.0', true);

    wp_localize_script( 'wpb_wmca_main_script', 'wpb_wmca_accordion', array( 
      'accordion_trigger' => apply_filters( 'wpb_wmca_accordion_trigger', 'click' ), // click, mouseenter
    ));
  }

  public function widget_register_styles(){
    $wpb_wmca_load_font_awesome   = wpb_wmca_get_option( 'wpb_wmca_load_font_awesome', 'other_settings', 'yes' );

    if( $wpb_wmca_load_font_awesome && $wpb_wmca_load_font_awesome == 'yes' ){
      wp_register_style( 'wpb_wmca_font_awesome_style_frontend', plugins_url('../admin/assets/css/font-awesome.min.css', __FILE__), '', '1.0' );
    }
    wp_register_style( 'wpb_wmca_accordion_style', plugins_url('../assets/css/wpb_wmca_style.css', __FILE__), '', '1.0' );
  }

  public function widget_enqueue_styles(){    
    $wpb_wmca_load_font_awesome   = wpb_wmca_get_option( 'wpb_wmca_load_font_awesome', 'other_settings', 'yes' );

    if( $wpb_wmca_load_font_awesome && $wpb_wmca_load_font_awesome == 'yes' ){
      wp_enqueue_style( 'wpb_wmca_font_awesome_style_frontend', plugins_url('../admin/assets/css/font-awesome.min.css', __FILE__), '', '1.0' );
    }
    wp_enqueue_style( 'wpb_wmca_accordion_style', plugins_url('../assets/css/wpb_wmca_style.css', __FILE__), '', '1.0' );
  }

  public function widgets_registered() {
    if(defined('ELEMENTOR_PATH') && class_exists('Elementor\Widget_Base')){
      require_once( WPB_WAMC_Plugin_EL_Template_Path . 'wpb-accordion-menu-elementor-widget.php' );
      require_once( WPB_WAMC_Plugin_EL_Template_Path . 'wpb-accordion-categories-elementor-widget.php' );
    }
  }
}

WPB_FP_Elementor_Element::get_instance()->init();