<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class WPB_Accordion_Menu_Widget extends Widget_Base {

	public function get_name() {
		return 'wpb_accordion_menu_pro';
	}

	public function get_title() {
		return esc_html__( 'WPB Accordion Menu', 'wpb-accordion-menu-or-category' );
	}

	public function get_icon() {
		return 'eicon-accordion';
	}

  public function is_reload_preview_required(){
    return true;
  }

	public function get_categories() {
		return [ 'wpb_widgets' ];
	}

	protected function _register_controls() {
    $this->start_controls_section(
      'wpb_wmca_settings',
      [
        'label' => esc_html__( 'Accordion Menu Settings', 'wpb-accordion-menu-or-category' )
      ]
    );

    $locations = get_nav_menu_locations();
    $menu_locations[''] = esc_html__( 'Select a theme location', 'wpb-accordion-menu-or-category' );
    foreach ($locations as $key => $location) {
      if( $location != 0 ){
        $menu_locations[$key] = $key;
      }
    }

    $this->add_control(
        'theme_location',
        [
            'label'         => esc_html__( 'Select a Theme Location', 'wpb-accordion-menu-or-category' ),
            'type'          => Controls_Manager::SELECT,             
            'options'       => $menu_locations,             
        ]
    );

    $nav_menus = get_terms('nav_menu');
    $nav_menu_options[''] = esc_html__( 'Select a Menu', 'wpb-accordion-menu-or-category' );
    foreach ($nav_menus as $nav_menu) {
      $nav_menu_options[$nav_menu->slug] = $nav_menu->name;
    }

    $this->add_control(
        'menu',
        [
            'label'         => esc_html__( 'Or Aelect a Menu', 'wpb-accordion-menu-or-category' ),
            'type'          => Controls_Manager::SELECT,             
            'options'       => $nav_menu_options,             
        ]
    );

    $this->add_control(
      'accordion',
      [
        'type'          => Controls_Manager::SWITCHER,
        'label'         => esc_html__( 'Close Previously Opened Accordion?', 'wpb-accordion-menu-or-category' ),
        'return_value'  => 'yes',
        'default'       => 'yes',
      ]
    );

    $this->add_control(
      'depth',
      [
        'label'         => esc_html__( 'Menu Depth', 'wpb-accordion-menu-or-category' ),
        'description'   => esc_html__('How many levels of the hierarchy are to be included where 0 means all.', 'wpb-accordion-menu-or-category'),
        'type'          => Controls_Manager::NUMBER,
        'min'           => 0,
        'default'       => '0',
      ]
    );

    $this->add_control(
        'theme',
        [
            'label'         => esc_html__( 'Accordion Style', 'wpb-accordion-menu-or-category' ),
            'type'          => Controls_Manager::SELECT,
            'default'       => 'dark',              
            'options'       => wpb_wmca_accordion_skins(),             
        ]
    );

    if( class_exists('JCSubmenu') ){
      $this->add_control(
        'jc_submenu',
        [
          'type'          => Controls_Manager::SWITCHER,
          'label'         => esc_html__( 'Add support of JC Submenu?', 'wpb-accordion-menu-or-category' ),
          'return_value'  => 'yes',
          'default'       => 'no',
        ]
      );
    }

    $this->end_controls_section();
	}

  protected function render() {
    $settings         = $this->get_settings_for_display();
    $theme            =  $settings['theme'];
    $theme_location   =  $settings['theme_location'];
    $menu             =  $settings['menu'];
    $accordion        =  $settings['accordion'];
    $depth            =  $settings['depth'];
    $jc_submenu       =  ( array_key_exists('jc_submenu', $settings) ? $settings['jc_submenu'] : '' ) ;

    if( !isset( $theme ) ){
      $theme = 'dark';
    }

    if( isset($_GET['skin']) ) {
      $theme = $_GET['skin'];
    }

    echo do_shortcode( '[wpb_menu_accordion theme="'.$theme.'" theme_location="'.$theme_location.'" menu="'.$menu.'" accordion="'.$accordion.'" depth="'.$depth.'" jc_submenu="'.$jc_submenu.'"]' );
  }
}

Plugin::instance()->widgets_manager->register_widget_type( new WPB_Accordion_Menu_Widget() );