<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // If this file is called directly, abort.

class WPB_Accordion_Categories_Widget extends Widget_Base {

	public function get_name() {
		return 'wpb_accordion_categories_pro';
	}

	public function get_title() {
		return esc_html__( 'WPB Categories Accordion', 'wpb-accordion-menu-or-category' );
	}

	public function get_icon() {
		return 'eicon-accordion';
	}

    public function is_reload_preview_required(){
        return true;
    }

	public function get_categories() {
		return [ 'wpb_widgets' ];
	}

	protected function _register_controls() {
        $taxonomies = get_taxonomies( array( 'public' => true ));
        $taxonomy_options[''] = esc_html__( 'Select a Taxonomy', 'wpb-accordion-menu-or-category' );
        $exclude = array( 'post_format', 'product_shipping_class' );

        foreach ($taxonomies as $taxonomy) {
          if( in_array( $taxonomy, $exclude ) ) {
            continue;
          }
          $taxonomy_options[$taxonomy] = $taxonomy;
        }

        $taxonomies_object = get_taxonomies(array( 'public' => true ), 'objects');


        $post_types = get_post_types( apply_filters( 'wpb_wmca_get_post_types_args', array( 'public' => true, 'exclude_from_search' => false ) ) );
        foreach ( $post_types as $post_type ) {
            $post_types_options[$post_type] = $post_type;
        }


        $this->start_controls_section(
          'wpb_wmca_cat_basic_settings',
          [
            'label' => esc_html__( 'Accordion Basic Settings', 'wpb-accordion-menu-or-category' )
          ]
        );

        $this->add_control(
            'theme',
            [
                'label'         => esc_html__( 'Accordion Style', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'dark',              
                'options'       => wpb_wmca_accordion_skins(),             
            ]
        );

        $this->add_control(
            'taxonomy',
            [
                'label'         => esc_html__( 'Select a Taxonomy', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'category',                 
                'options'       => $taxonomy_options,             
            ]
        );

        $this->add_control(
            'orderby',
            [
                'label'         => esc_html__( 'Taxonomy Orderby', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'name',                 
                'options' => [
                    'ID'            => esc_html__( 'ID', 'wpb-accordion-menu-or-category' ),
                    'name'          => esc_html__( 'name', 'wpb-accordion-menu-or-category' ),
                    'slug'          => esc_html__( 'slug', 'wpb-accordion-menu-or-category' ),
                    'count'         => esc_html__( 'count', 'wpb-accordion-menu-or-category' ),
                    'term_group'    => esc_html__( 'term_group', 'wpb-accordion-menu-or-category' ),
                    'menu_order'    => esc_html__( 'menu_order', 'wpb-accordion-menu-or-category' ),
                ],           
            ]
        );

        $this->add_control(
            'order',
            [
                'label'         => esc_html__( 'Taxonomy Order', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'ASC',                 
                'options' => [
                    'ASC'            => esc_html__( 'ASC', 'wpb-accordion-menu-or-category' ),
                    'DESC'           => esc_html__( 'DESC', 'wpb-accordion-menu-or-category' ),
                ],           
            ]
        );

        $this->add_control(
            'hide_empty',
            [
                'label'         => esc_html__( 'Hide Empty', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'accordion',
            [
                'label'         => esc_html__( 'Close previously opened accordion', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'yes',
            ]
        );

        $this->add_control(
            'number',
            [
                'label'     => esc_html__( 'Number of categories', 'wpb-accordion-menu-or-category' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'step'      => 1,
                'default'   => 0,
            ]
        );

        $this->add_control(
            'depth',
            [
                'label'         => esc_html__( 'Category Depth', 'wpb-accordion-menu-or-category' ),
                'description'   => esc_html__( 'Category depth, Set 0 to show all.', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::NUMBER,
                'min'           => 0,
                'step'          => 1,
                'default'       => 0,
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
          'wpb_wmca_cat_advanced_settings',
          [
            'label' => esc_html__( 'Accordion Advanced Settings', 'wpb-accordion-menu-or-category' )
          ]
        );

        foreach ($taxonomies_object as $taxonomy => $object) {
            if ( !isset($object->object_type[0]) || in_array( $object->name, $exclude ) ) {
              continue;
            }

            $this->add_control(
                $taxonomy . '_exclude_ids',
                [
                    'label'         => esc_html__( 'Exclude ', 'wpb-accordion-menu-or-category' ) . $object->label,
                    'type'          => Controls_Manager::SELECT2,
                    'label_block'   => true,
                    'multiple'      => true,
                    'object_type'   => $taxonomy,
                    'options'       => wp_list_pluck(get_terms(array( 'taxonomy' => $taxonomy, 'hide_empty' => false, 'orderby' => 'menu_order' )), 'name', 'term_id'),
                    'condition'     => [
                        'taxonomy' => $object->name,
                    ],
                ]
            );
        }

        foreach ($taxonomies_object as $taxonomy => $object) {
            if ( !isset($object->object_type[0]) || in_array( $object->name, $exclude ) ) {
              continue;
            }

            $this->add_control(
                $taxonomy . '_include_ids',
                [
                    'label'         => esc_html__( 'Include ', 'wpb-accordion-menu-or-category' ) . $object->label,
                    'type'          => Controls_Manager::SELECT2,
                    'label_block'   => true,
                    'multiple'      => true,
                    'object_type'   => $taxonomy,
                    'options'       => wp_list_pluck(get_terms(array( 'taxonomy' => $taxonomy, 'hide_empty' => false, 'orderby' => 'menu_order' )), 'name', 'term_id'),
                    'condition'     => [
                        'taxonomy' => $object->name,
                    ],
                ]
            );
        }

        $this->add_control(
            'show_count',
            [
                'label'         => esc_html__( 'Show Count', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'Hide', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'show_icon',
            [
                'label'         => esc_html__( 'Show Category Icons', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'yes',
            ]
        );

        $this->add_control(
            'only_child',
            [
                'label'         => esc_html__( 'Show only child items of a active category', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'hierarchical',
            [
                'label'         => esc_html__( 'Display all subcategories in the same level', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
          'wpb_wmca_show_posts',
          [
            'label' => esc_html__( 'Show Post', 'wpb-accordion-menu-or-category' )
          ]
        );

        $this->add_control(
            'show_posts',
            [
                'label'         => esc_html__( 'Show Category Posts?', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
            ]
        );

        $this->add_control(
            'post_type',
            [
                'label'         => esc_html__( 'Select a Post Type', 'wpb-accordion-menu-or-category' ),
                'description'   => esc_html__( 'Post type that associated with the taxonomy you selected.', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SELECT,
                'default'       => 'post',                 
                'options'       => $post_types_options,
                'condition'     => [
                    'show_posts' => 'yes',
                ],            
            ]
        );

        $this->add_control(
            'numberposts',
            [
                'label'     => esc_html__( 'Number of Posts', 'wpb-accordion-menu-or-category' ),
                'type'      => Controls_Manager::NUMBER,
                'min'       => 0,
                'step'      => 1,
                'default'   => 3,
            ]
        );

        $this->add_control(
            'only_top_cats_with_posts',
            [
                'label'         => esc_html__( 'Show only top level categories with posts?', 'wpb-accordion-menu-or-category' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                'label_off'     => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                'return_value'  => 'yes',
                'default'       => 'no',
                'condition'     => [
                    'show_posts' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
          'wpb_wmca_cat_style',
          [
            'label' => esc_html__( 'Style Settings', 'wpb-accordion-menu-or-category' )
          ]
        );

        $this->add_control(
            'background_color',
            [
                'label'     => esc_html__( 'Background Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#3b424d',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'background_color_hover',
            [
                'label'     => esc_html__( 'Background Color Hover', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#383F4A',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'child_background_color',
            [
                'label'     => esc_html__( 'Child Background Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#383838',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom ul > li li' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'child_background_color_hover',
            [
                'label'     => esc_html__( 'Child Background Color Hover', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#383838',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom ul > li li > a:hover' => 'background: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label'     => esc_html__( 'Text Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#f5f5f5',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a:visited' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'text_color_hover',
            [
                'label'     => esc_html__( 'Text Color Hover', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#f5f5f5',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li a:hover' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'border_color',
            [
                'label'     => esc_html__( 'Border Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#414956',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul li > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul ul li > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li li:hover > a' => 'border-left-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom li.wpb-submenu-indicator-minus > a' => 'border-left-color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'border_color_hover',
            [
                'label'     => esc_html__( 'Border Color Hover', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'default'   => '#414956',
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li > a:hover' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul li > a:hover' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul ul ul li > a:hover' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul > li li:hover > a:hover' => 'border-left-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom li.wpb-submenu-indicator-minus > a:hover' => 'border-left-color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'current_border_color',
            [
                'label'     => esc_html__( 'Current Item Border Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a' => 'border-bottom-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a' => 'border-left-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a' => 'border-left-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a' => 'border-left-color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'current_color',
            [
                'label'     => esc_html__( 'Current Item Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a' => 'color: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'current_bg_color',
            [
                'label'     => esc_html__( 'Current Item Background Color', 'wpb-accordion-menu-or-category' ),
                'type'      => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-cat > a' => 'background-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.current-menu-item > a' => 'background-color: {{VALUE}}!important',
                    '{{WRAPPER}} .wpb_category_n_menu_accordion.wpb_wmca_theme_custom > ul li.wpb-wcma-current-post > a' => 'background-color: {{VALUE}}!important',
                ],
            ]
        );

        $this->end_controls_section();
	}

    protected function render() {
        $settings         = $this->get_settings_for_display();
        $theme            =  $settings['theme'];
        $taxonomy         =  $settings['taxonomy'];
        $exclude          =  $settings[$taxonomy.'_exclude_ids'];
        $include          =  $settings[$taxonomy.'_include_ids'];
        $orderby          =  $settings['orderby'];
        $order            =  $settings['order'];
        $show_count       =  $settings['show_count'];
        $hide_empty       =  $settings['hide_empty'];
        $show_icon        =  $settings['show_icon'];
        $only_child       =  $settings['only_child'];
        $hierarchical     =  $settings['hierarchical'];
        $number           =  $settings['number'];
        $depth            =  $settings['depth'];
        $accordion        =  $settings['accordion'];
        $show_posts       =  $settings['show_posts'];
        $only_top_cats    =  $settings['only_top_cats_with_posts'];
        $post_type        =  $settings['post_type'];
        $numberposts      =  $settings['numberposts'];

        if( !isset( $theme ) ){
          $theme = 'dark';
        }

        if( isset($_GET['skin']) ) {
          $theme = $_GET['skin'];
        }

        echo do_shortcode( '[wpb_category_accordion theme="'.$theme.'" taxonomy="'.$taxonomy.'" exclude="'.( !empty($exclude) ? implode (', ', $exclude) : '' ).'" include="'.( !empty($include) ? implode (', ', $include) : '' ).'" orderby="'.$orderby.'" order="'.$order.'" show_count="'.$show_count.'" hide_empty="'.$hide_empty.'" show_icon="'.$show_icon.'" only_child="'.$only_child.'" hierarchical="'.$hierarchical.'" number="'.$number.'" depth="'.$depth.'" accordion="'.$accordion.'" show_posts="'.$show_posts.'" only_top_cats_with_posts="'.$only_top_cats.'" post_type="'.$post_type.'" numberposts="'.$numberposts.'"]' );
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new WPB_Accordion_Categories_Widget() );