(function($) {
  "use strict";

  	var WPB_WMCA_Accordion = function($scope, $){

      	var $_wpb_wmca = $scope.find(".wpb_category_n_menu_accordion");

      	/**
      	 * Init the Accordion
      	 */
      	
        $_wpb_wmca.each(function() {

            var accordion 		= $(this).data('accordion'),
				indicator_icon  = $(this).data('indicator_icon'),
				caretHtml       = '';

			if( indicator_icon ){
				caretHtml = '<i class="' + indicator_icon + '"></i>';
			}

			$(this).find('.wpb_category_n_menu_accordion_list').navgoco({
				caretHtml: caretHtml,
				accordion: accordion,
				openClass: 'wpb-submenu-indicator-minus',
				save: true,
				cookie: {
					name: 'navgoco',
					expires: false,
					path: '/'
				},
				slide: {
					duration: 400,
					easing: 'swing'
				}
	      	});
        });



        /**
		 * Auto Open Parent with Sub Menu 
		 */
		
		$('.wpb_category_n_menu_accordion.wpb_wcma_manu_parent_open_on > ul > li.wpb-wmca-menu-item-has-children > ul').show();
		$('.wpb_category_n_menu_accordion.wpb_wcma_manu_parent_open_on > ul > li.wpb-wmca-menu-item-has-children').addClass('wpb-submenu-indicator-minus');

		$('.wpb_category_n_menu_accordion.wpb_wcma_manu_parent_open_on > ul > li.menu-item-has-children > ul').show();
	    $('.wpb_category_n_menu_accordion.wpb_wcma_manu_parent_open_on > ul > li.menu-item-has-children').addClass('wpb-submenu-indicator-minus');


		/**
		 * Auto Open All the Parent Cats with Sub Cat
		 */
		
		$('.wpb_category_n_menu_accordion.wpb_wcma_cat_parent_open_on > ul > li.cat-item-have-child > ul').show();
		$('.wpb_category_n_menu_accordion.wpb_wcma_cat_parent_open_on > ul > li.cat-item-have-child').addClass('wpb-submenu-indicator-minus');


		/**
		 * Keep Current Menu Open
		 */

		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on .current-menu-item').parents('ul.sub-menu').show();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on .current-menu-item').parents('li.menu-item-has-children').addClass('wpb-submenu-indicator-minus');

		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on .current-menu-item.wpb-wmca-menu-item-has-children > ul.sub-menu').show();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on .current-menu-item.wpb-wmca-menu-item-has-children').addClass('wpb-submenu-indicator-minus');

		/**
		 * Keep Current Menu Close
		 */

		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_off .current-menu-item').parents('ul.sub-menu').hide();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_off .current-menu-item').parents('li.menu-item-has-children').removeClass('wpb-submenu-indicator-minus');


		/**
		 * Keep Selected Menu Open
		 */
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on > ul li.wpb-wmca-menu-item-has-children.wpb_wmca_menu_item_keep_open > ul').show();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_menu_open_on > ul li.wpb-wmca-menu-item-has-children.wpb_wmca_menu_item_keep_open').addClass('wpb-submenu-indicator-minus');


		/**
		 * Keep Current Category Open
		 */
		
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_on .current-cat').parents('ul.wpb-wcma-children').show();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_on .current-cat').parents('li.cat-item-have-child').addClass('wpb-submenu-indicator-minus');

		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_on .current-cat > ul.wpb-wcma-children').show();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_on .current-cat > ul.wpb-wcma-children.cat-item-have-child').addClass('wpb-submenu-indicator-minus');

		/**
		 * Keep Current Category close
		 */
		
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_off .current-cat').parents('ul.wpb-wcma-children').hide();
		$('.wpb_category_n_menu_accordion.wpb_wmca_current_cat_open_off .current-cat').parents('li.cat-item-have-child').removeClass('wpb-submenu-indicator-minus');


		/**
		 * Show Posts items in category accordion 
		 */

		$('.wpb_category_n_menu_accordion.wpb_wmca_show_posts_yes > ul > li.cat-item-have-child.wpb-wmca-cat-item-have-posts').each(function(){
			$(this).find('> ul.wpb-wcma-children-cats').append( $(this).find('> ul.wpb-wcma-children-posts li'));
			$(this).find('> ul.wpb-wcma-children-posts').remove();
		});
    };

	// Elementor FrontEnd Hooks
	$(window).on('elementor/frontend/init', function () {
		elementorFrontend.hooks.addAction('frontend/element_ready/wpb_accordion_menu_pro.default', WPB_WMCA_Accordion);
		elementorFrontend.hooks.addAction('frontend/element_ready/wpb_accordion_categories_pro.default', WPB_WMCA_Accordion);
	});

}(jQuery));