<?php

/*
	WPB Menu & Category Accordion
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

/**
 * Register Widgets
 */

function register_wpb_wmca_widgets() {
	register_widget( 'wpb_wmca_menu_accordion_Widget' );
    register_widget( 'wpb_wmca_category_accordion_Widget' );
}
add_action( 'widgets_init', 'register_wpb_wmca_widgets' );


/**
 * Menu Accordion Widget
 */

class wpb_wmca_menu_accordion_Widget extends WP_Widget {

	/**
	 * Register widget
	 */
	function __construct() {
		parent::__construct(
			'wpb_wmca_menu_accordion_widget', // Base ID
			esc_html__( 'WPB Menu Accordion', 'wpb-accordion-menu-or-category' ), // Name
			array( 'description' => esc_html__( 'Dispay accordion of WordPress menu.', 'wpb-accordion-menu-or-category' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {

		extract( $args );
		extract( $instance );

		echo $before_widget;

		if ( ! empty( $title ) ) {
			echo $before_title . apply_filters( 'widget_title', $title ). $after_title;
		}

		if( !isset( $jc_submenu ) ){
			$jc_submenu = '';
		}

		echo do_shortcode( '[wpb_menu_accordion theme_location="'.$theme_location.'" menu="'.$menu.'" theme="'.$theme.'" accordion="'.( isset($accordion) && $accordion == 'on' ? 'yes' : 'no' ).'" depth="'.$depth.'" xclass="'.$xclass.'" jc_submenu="'.( isset($jc_submenu) && $jc_submenu == 'on' ? 'yes' : 'no' ).'"]' );

		echo $after_widget;
	}

	/**
	 * Back-end widget form.
	 */
	public function form( $instance ) {
		extract( $instance );
		if( !isset( $title ) ){
			$title = '';
		}
		if( !isset( $theme_location ) ){
			$theme_location = '';
		}
		if( !isset( $menu ) ){
			$menu = '';
		}
		if( !isset( $accordion ) ){
			$accordion = 'on';
		}
		if( !isset( $depth ) ){
			$depth = '0';
		}
		if( !isset( $xclass ) ){
			$xclass = '';
		}
		if( !isset( $theme ) ){
			$theme = 'dark';
		}
		if( !isset( $jc_submenu ) ){
			$jc_submenu = '';
		}

		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ) ; ?>"><?php esc_html_e( 'Title:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ) ?>">
		</p>

		<strong><?php esc_html_e( 'Select a theme location or select a menu. Do not select theme location & menu at a time. Use one of it.', 'wpb-accordion-menu-or-category' ); ?></strong>

		<p>
			<?php $wpb_wmca_menu_locations = get_nav_menu_locations();?>
			<label for="<?php echo esc_attr( $this->get_field_id( 'theme_location' ) ); ?>"><?php esc_html_e( 'Select a theme location','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'theme_location' ) ) ; ?>" name="<?php echo esc_attr( $this->get_field_name( 'theme_location' ) ); ?>">
				<option value="" ><?php esc_html_e( '- Select an option -','wpb-accordion-menu-or-category' ); ?></option>
				<?php 
					foreach ($wpb_wmca_menu_locations as $key => $wpb_wmca_menu_location) {
						if( $wpb_wmca_menu_location != 0 ){
							?>
								<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $theme_location, $key ); ?>><?php echo esc_html( $key ); ?></option>
							<?php
						}
					}
				?>
			</select>
		</p>

		<p>
			<?php $wpb_wmca_menus = get_terms('nav_menu'); ?>
			<label for="<?php echo esc_attr( $this->get_field_id( 'menu' ) ); ?>"><?php esc_html_e( 'Or select a menu','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'menu' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'menu' )); ?>">
				<option value="" ><?php esc_html_e( '- Select an option -','wpb-accordion-menu-or-category' ); ?></option>
				<?php 
					foreach ( $wpb_wmca_menus as $wpb_wmca_menu ) {
						?>
							<option value="<?php echo esc_attr( $wpb_wmca_menu->slug ); ?>" <?php selected( $wpb_wmca_menu->slug, $menu ); ?>><?php echo esc_html( $wpb_wmca_menu->name ); ?></option>
						<?php
					}
				?>
			</select>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Close previously opened accordion','wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'accordion' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'accordion' )); ?>" <?php checked( $accordion, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'accordion' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'depth' )); ?>"><?php esc_html_e( 'Menu depth:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'depth' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'depth' )); ?>" type="number" value="<?php echo esc_attr( $depth ); ?>" required>
			<span class="wpb_widget_help"><?php esc_html_e( 'How many levels of the hierarchy are to be included where 0 means all.','wpb-accordion-menu-or-category' ); ?></span>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'xclass' )); ?>"><?php esc_html_e( 'Extra class:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'xclass' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'xclass' )); ?>" type="text" value="<?php echo esc_html($xclass); ?>">
		</p>

		<p>
			<?php $themes = wpb_wmca_accordion_skins(); ?>
			<label for="<?php echo esc_attr( $this->get_field_id( 'theme' ) ); ?>"><?php esc_html_e( 'Select a skin','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'theme' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'theme' )); ?>">
				<option value="" ><?php esc_html_e( '- Select an option -','wpb-accordion-menu-or-category' ); ?></option>
				<?php
					if( $themes && !empty($themes) ){
						foreach ( $themes as $key => $value ) {
							?>
								<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $theme ); ?>><?php echo esc_html( $value ); ?></option>
							<?php
						}
					}
				?>
			</select>
		</p>

		<?php if( class_exists('JCSubmenu') ): ?>
			<p>
				<span style="display: block"><?php esc_html_e( 'Add support of JC Submenu', 'wpb-accordion-menu-or-category' ); ?></span>
				<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'jc_submenu' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'jc_submenu' )); ?>" <?php checked( $jc_submenu, 'on' ); ?>>
				<label for="<?php echo esc_attr($this->get_field_id( 'jc_submenu' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
			</p>
		<?php endif; ?>

		<?php 
	}

	/**
	 * Sanitize widget form values as they are saved.
	 */
	public function update( $new_instance, $old_instance ) {
		$instance 						= array();
		$instance['title'] 				= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['theme_location'] 	= ( ! empty( $new_instance['theme_location'] ) ) ? strip_tags( $new_instance['theme_location'] ) : '';
		$instance['menu'] 				= ( ! empty( $new_instance['menu'] ) ) ? strip_tags( $new_instance['menu'] ) : '';
		$instance['accordion'] 			= ( ! empty( $new_instance['accordion'] ) ) ? strip_tags( $new_instance['accordion'] ) : '';
		$instance['depth'] 				= ( ! empty( $new_instance['depth'] ) ) ? strip_tags( $new_instance['depth'] ) : 0;
		$instance['xclass'] 			= ( ! empty( $new_instance['xclass'] ) ) ? strip_tags( $new_instance['xclass'] ) : '';
		$instance['theme'] 			    = ( ! empty( $new_instance['theme'] ) ) ? strip_tags( $new_instance['theme'] ) : '';

		if( class_exists('JCSubmenu') ){
			$instance['jc_submenu'] 		= ( ! empty( $new_instance['jc_submenu'] ) ) ? strip_tags( $new_instance['jc_submenu'] ) : '';
		}

		return $instance;
	}

}



/**
 * Category Accordion Widget
 */


class wpb_wmca_category_accordion_Widget extends WP_Widget {

	/**
	 * Register widget
	 */
	function __construct() {
		parent::__construct(
			'wpb_wmca_category_accordion_widget', // Base ID
			esc_html__( 'WPB Category Accordion', 'wpb-accordion-menu-or-category' ), // Name
			array( 'description' => esc_html__( 'Dispay accordion of WordPress Categories.', 'wpb-accordion-menu-or-category' ), ) // Args
		);
	}

	/**
	 * Front-end display of widget.
	 */
	public function widget( $args, $instance ) {

		extract( $args );
		extract( $instance );

		$exclude    = $instance['exclude'];
        if( isset( $exclude ) && $exclude != '' ){
			$wpb_wmca_exclude_cats_id_comma_seperated = implode (", ", $exclude);
		}else{
			$wpb_wmca_exclude_cats_id_comma_seperated = '';
		}

        $include    = $instance['include'];

        if( isset( $include ) && $include != '' ){
			$wpb_wmca_include_cats_id_comma_seperated = implode (", ", $include);
		}else{
			$wpb_wmca_include_cats_id_comma_seperated = '';
		}
        
		echo $before_widget;

		if ( ! empty( $title ) ) {
			echo $before_title . apply_filters( 'widget_title', $title ). $after_title;
		}

		echo do_shortcode( '[wpb_category_accordion taxonomy="'.$taxonomy.'" post_type="'.( isset($post_type) ? $post_type : 'post' ).'" theme="'.$theme.'" orderby="'.$orderby.'" order="'.$order.'" show_count="'.( isset($show_count) && $show_count == 'on' ? 'yes' : 'no' ).'" hide_empty="'.( $hide_empty && $hide_empty == 'on' ? 'yes' : 'no' ).'" show_icon="'.( $show_icon && $show_icon == 'on' ? 'yes' : 'no' ).'" only_child="'.( isset($only_child) && $only_child == 'on' ? 'yes' : 'no' ).'" hierarchical="'.( isset($hierarchical) && $hierarchical == 'on' ? 'yes' : 'no' ).'" number="'.$number.'" numberposts="'.( isset($numberposts) ? $numberposts : 3 ).'" depth="'.$depth.'" accordion="'.( isset($accordion) && $accordion == 'on' ? 'yes' : 'no' ).'" show_posts="'.( isset($show_posts) && $show_posts == 'on' ? 'yes' : 'no' ).'" only_top_cats_with_posts="'.( isset($only_top_cats_with_posts) && $only_top_cats_with_posts == 'on' ? 'yes' : 'no' ).'" xclass="'.$xclass.'" include="'.$wpb_wmca_include_cats_id_comma_seperated.'" exclude="'.$wpb_wmca_exclude_cats_id_comma_seperated.'"]' );

		echo $after_widget;
	}

	/**
	 * Back-end widget form.
	 */
	public function form( $instance ) {
		extract( $instance );

		if( !isset( $title ) ){
			$title = '';
		}
		if( !isset( $taxonomy ) ){
			$taxonomy = 'category';
		}
		if( !isset( $post_type ) ){
			$post_type = 'post';
		}
		if( !isset( $orderby ) ){
			$orderby = 'name';
		}
		if( !isset( $order ) ){
			$order = 'ASC';
		}
		if( !isset( $show_count ) ){
			$show_count = 'off';
		}
		if( !isset( $hide_empty ) ){
			$hide_empty = 'on';
		}
		if( !isset( $show_icon ) ){
			$show_icon = 'on';
		}
		if( !isset( $only_child ) ){
			$only_child = 'off';
		}
		if( !isset( $hierarchical ) ){
			$hierarchical = 'off';
		}
		if( !isset( $number ) ){
			$number = '0';
		}
		if( !isset( $numberposts ) ){
			$numberposts = 3;
		}
		if( !isset( $depth ) ){
			$depth = '0';
		}
		if( !isset( $accordion ) ){
			$accordion = 'on';
		}
		if( !isset( $show_posts ) ){
			$show_posts = 'off';
		}
		if( !isset( $only_top_cats_with_posts ) ){
			$only_top_cats_with_posts = 'off';
		}
		if( !isset( $xclass ) ){
			$xclass = '';
		}
		if( !isset( $theme ) ){
			$theme = 'dark';
		}
		if( !array_key_exists('exclude', $instance) ){
			$instance['exclude'] = array();
		}
		if( !array_key_exists('include', $instance) ){
			$instance['include'] = array();
		}
		?>

		<p>
			<label for="<?php echo esc_attr( $this->get_field_id( 'title' ) ) ; ?>"><?php esc_html_e( 'Title:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'title' ) ); ?>" name="<?php echo esc_attr($this->get_field_name( 'title' )); ?>" type="text" value="<?php echo esc_html( $title ) ?>">
		</p>

		<p>
			<?php 
				$wpb_wmca_texonomies = get_taxonomies( array( 'public' => true ) );
			?>
			<label for="<?php echo esc_attr($this->get_field_id( 'taxonomy' )); ?>"><?php esc_html_e( 'Select a taxonomy','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'taxonomy' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'taxonomy' )); ?>">
				<?php
					foreach ( $wpb_wmca_texonomies as $wpb_wmca_texonomie ) {
						echo '<option value="'. esc_attr( $wpb_wmca_texonomie ) .'" '. selected( $wpb_wmca_texonomie, $taxonomy, false ) .'>' . esc_html( $wpb_wmca_texonomie ) . '</option>';
					}
				?>
			</select>
		</p>

		<p><b><?php esc_html_e( 'Either use exclude or include, don\'t use both together.', 'wpb-accordion-menu-or-category' ) ?></b></p>

        <p>
        	<?php
	        	$exclude_texonomies = get_terms( array(
				    'taxonomy' 		=> $taxonomy,
				    'hide_empty' 	=> false,
				));
			?>
            <label style="display: block" for="<?php echo esc_attr($this->get_field_id('exclude')); ?>"><?php esc_html_e('Exclude Categories', 'wpb-accordion-menu-or-category'); ?></label>
            <select class="wpb-wmca-widget-select" id="<?php echo esc_attr($this->get_field_id( 'exclude' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'exclude' )); ?>[]" multiple style="min-height: 130px;">
				<?php
					foreach ( $exclude_texonomies as $exclude_taxonomy ) {
						if( is_array($instance['exclude']) ){
							$selected = in_array( $exclude_taxonomy->term_id, $instance['exclude'] ) ? ' selected="selected" ' : ''; 
						}else{
							$selected = '';
						}

						echo '<option value="'. esc_attr( $exclude_taxonomy->term_id ) .'"  '. $selected .'>' . esc_html( $exclude_taxonomy->name . '('.$exclude_taxonomy->count.')') . '</option>';
					}
				?>
			</select>
			<input type="button" class="button wpb-wmca-btn-deselect" value="<?php esc_html_e( 'Deselect All', 'wpb-accordion-menu-or-category' ) ?>"/>
        </p>

        <p>
        	<?php 
        		$include_texonomies = get_terms( array(
				    'taxonomy' 		=> $taxonomy,
				    'hide_empty' 	=> false,
				));
        	?>
            <label style="display: block" for="<?php echo esc_attr($this->get_field_id('include')); ?>"><?php esc_html_e('Include Categories','wpb-accordion-menu-or-category'); ?></label>
            <select class="wpb-wmca-widget-select" id="<?php echo esc_attr($this->get_field_id( 'include' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'include' )); ?>[]" multiple style="min-height: 130px;">
				<?php
					foreach ( $include_texonomies as $include_taxonomy ) {

						if( is_array($instance['include']) ){
							$selected = in_array( $include_taxonomy->term_id, $instance['include'] ) ? ' selected="selected" ' : ''; 
						}else{
							$selected = '';
						}

						echo '<option value="'. esc_attr( $include_taxonomy->term_id ) .'"  '. $selected .'>' . esc_html( $include_taxonomy->name . '('.$include_taxonomy->count.')') . '</option>';
					}
				?>
			</select>
			<input type="button" class="button wpb-wmca-btn-deselect" value="<?php esc_html_e( 'Deselect All', 'wpb-accordion-menu-or-category' ) ?>"/>
        </p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>"><?php esc_html_e( 'Orderby','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'orderby' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'orderby' )); ?>">
				<option value="ID" <?php selected( $orderby, 'ID' ); ?>><?php esc_html_e( 'ID','wpb-accordion-menu-or-category' ); ?></option>
				<option value="name" <?php selected( $orderby, 'name' ); ?>><?php esc_html_e( 'Name','wpb-accordion-menu-or-category' ); ?></option>
				<option value="slug" <?php selected( $orderby, 'slug' ); ?>><?php esc_html_e( 'Slug','wpb-accordion-menu-or-category' ); ?></option>
				<option value="count" <?php selected( $orderby, 'count' ); ?>><?php esc_html_e( 'Count','wpb-accordion-menu-or-category' ); ?></option>
				<option value="term_group" <?php selected( $orderby, 'term_group' ); ?>><?php esc_html_e( 'Term Group','wpb-accordion-menu-or-category' ); ?></option>
				<option value="menu_order" <?php selected( $orderby, 'menu_order' ); ?>><?php esc_html_e( 'Menu Order','wpb-accordion-menu-or-category' ); ?></option>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'order' )); ?>"><?php esc_html_e( 'Order','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'order' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'order' )); ?>">
				<option value="ASC" <?php selected( $order, 'ASC' ); ?>><?php esc_html_e( 'Ascending','wpb-accordion-menu-or-category' ); ?></option>
				<option value="DESC" <?php selected( $order, 'DESC' ); ?>><?php esc_html_e( 'Descending','wpb-accordion-menu-or-category' ); ?></option>
			</select>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Show post count in category','wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'show_count' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_count' )); ?>" <?php checked( $show_count, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_count' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Hide empty categories','wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'hide_empty' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hide_empty' )); ?>" <?php checked( $hide_empty, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'hide_empty' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Show category icons','wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'show_icon' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_icon' )); ?>" <?php checked( $show_icon, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_icon' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Show only child categories of active category','wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'only_child' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'only_child' )); ?>" <?php checked( $only_child, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'only_child' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Display sub-categories as inner list items (below the parent list item) or inline', 'wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'hierarchical' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'hierarchical' )); ?>" <?php checked( $hierarchical, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'hierarchical' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'number' )); ?>"><?php esc_html_e( 'Number of categories','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'number' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'number' )); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" required>
			<span class="wpb_widget_help"><?php esc_html_e( 'How many categories to show where 0 means all.','wpb-accordion-menu-or-category' ); ?></span>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'depth' )); ?>"><?php esc_html_e( 'Category depth:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'depth' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'depth' )); ?>" type="number" value="<?php echo esc_attr( $depth ); ?>" required>
			<span class="wpb_widget_help"><?php esc_html_e( ' This parameter controls how many levels in the hierarchy of Categories are to be included in the list of Categories where 0 means all.','wpb-accordion-menu-or-category' ); ?></span>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Close previously opened accordion', 'wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'accordion' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'accordion' )); ?>" <?php checked( $accordion, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'accordion' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<?php $themes = wpb_wmca_accordion_skins(); ?>
			<label for="<?php echo esc_attr( $this->get_field_id( 'theme' ) ); ?>"><?php esc_html_e( 'Select a theme','wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'theme' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'theme' )); ?>">
				<option value="" ><?php esc_html_e( '- Select an option -','wpb-accordion-menu-or-category' ); ?></option>
				<?php
					if( $themes && !empty($themes) ){
						foreach ( $themes as $key => $value ) {
							?>
								<option value="<?php echo esc_attr( $key ); ?>" <?php selected( $key, $theme ); ?>><?php echo esc_html( $value ); ?></option>
							<?php
						}
					}
				?>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'xclass' )); ?>"><?php esc_html_e( 'Extra class:','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'xclass' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'xclass' )); ?>" type="text" value="<?php echo esc_html($xclass); ?>">
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Show Category Posts?', 'wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'show_posts' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'show_posts' )); ?>" <?php checked( $show_posts, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'show_posts' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<span style="display: block"><?php esc_html_e( 'Show only top level categories with posts?', 'wpb-accordion-menu-or-category' ); ?></span>
			<input class="checkbox" type="checkbox" id="<?php echo esc_attr($this->get_field_id( 'only_top_cats_with_posts' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'only_top_cats_with_posts' )); ?>" <?php checked( $only_top_cats_with_posts, 'on' ); ?>>
			<label for="<?php echo esc_attr($this->get_field_id( 'only_top_cats_with_posts' )); ?>"><?php esc_html_e( 'Yes please.','wpb-accordion-menu-or-category' ); ?></label>
		</p>

		<p>
			<?php $wpb_wmca_post_types = get_post_types( apply_filters( 'wpb_wmca_get_post_types_args', array( 'public' => true, 'exclude_from_search' => false ) ) ); ?>
			<label for="<?php echo esc_attr($this->get_field_id( 'post_type' )); ?>"><?php esc_html_e( 'Select Post Type for Your Selected Taxonomy', 'wpb-accordion-menu-or-category' ); ?></label> 
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id( 'post_type' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'post_type' )); ?>">
				<?php
					foreach ( $wpb_wmca_post_types as $wpb_wmca_post_type ) {
						echo '<option value="'. esc_attr( $wpb_wmca_post_type ) .'" '. selected( $wpb_wmca_post_type, $post_type, false ) .'>' . esc_html( $wpb_wmca_post_type ) . '</option>';
					}
				?>
			</select>
		</p>

		<p>
			<label for="<?php echo esc_attr($this->get_field_id( 'numberposts' )); ?>"><?php esc_html_e( 'Number of Posts','wpb-accordion-menu-or-category' ); ?></label> 
			<input class="widefat" id="<?php echo esc_attr($this->get_field_id( 'numberposts' )); ?>" name="<?php echo esc_attr($this->get_field_name( 'numberposts' )); ?>" type="number" value="<?php echo esc_attr( $numberposts ); ?>">
			<span class="wpb_widget_help"><?php esc_html_e( 'How many posts to show. Default: 3','wpb-accordion-menu-or-category' ); ?></span>
		</p>


		<?php
	}

	/**
	 * Sanitize widget form values as they are saved.
	 */

	public function update( $new_instance, $old_instance ) {
		$instance 					= array();
		$instance['title'] 			= ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['taxonomy'] 		= ( ! empty( $new_instance['taxonomy'] ) ) ? strip_tags( $new_instance['taxonomy'] ) : '';
		$instance['post_type'] 		= ( ! empty( $new_instance['post_type'] ) ) ? strip_tags( $new_instance['post_type'] ) : '';
		$instance['orderby'] 		= ( ! empty( $new_instance['orderby'] ) ) ? strip_tags( $new_instance['orderby'] ) : '';
		$instance['order'] 			= ( ! empty( $new_instance['order'] ) ) ? strip_tags( $new_instance['order'] ) : '';
		$instance['show_count'] 	= ( ! empty( $new_instance['show_count'] ) ) ? strip_tags( $new_instance['show_count'] ) : '';
		$instance['hide_empty'] 	= ( ! empty( $new_instance['hide_empty'] ) ) ? strip_tags( $new_instance['hide_empty'] ) : '';
		$instance['show_icon'] 		= ( ! empty( $new_instance['show_icon'] ) ) ? strip_tags( $new_instance['show_icon'] ) : '';
		$instance['only_child'] 	= ( ! empty( $new_instance['only_child'] ) ) ? strip_tags( $new_instance['only_child'] ) : '';
		$instance['hierarchical'] 	= ( ! empty( $new_instance['hierarchical'] ) ) ? strip_tags( $new_instance['hierarchical'] ) : '';
		$instance['number'] 		= ( ! empty( $new_instance['number'] ) ) ? strip_tags( $new_instance['number'] ) : 0;
		$instance['numberposts'] 	= ( ! empty( $new_instance['numberposts'] ) ) ? strip_tags( $new_instance['numberposts'] ) : 0;
		$instance['depth'] 			= ( ! empty( $new_instance['depth'] ) ) ? strip_tags( $new_instance['depth'] ) : 0;
		$instance['accordion'] 		= ( ! empty( $new_instance['accordion'] ) ) ? strip_tags( $new_instance['accordion'] ) : '';
		$instance['show_posts'] 	= ( ! empty( $new_instance['show_posts'] ) ) ? strip_tags( $new_instance['show_posts'] ) : '';
		$instance['only_top_cats_with_posts'] 	= ( ! empty( $new_instance['only_top_cats_with_posts'] ) ) ? strip_tags( $new_instance['only_top_cats_with_posts'] ) : '';
		$instance['xclass'] 		= ( ! empty( $new_instance['xclass'] ) ) ? strip_tags( $new_instance['xclass'] ) : '';
		$instance['theme'] 		    = ( ! empty( $new_instance['theme'] ) ) ? strip_tags( $new_instance['theme'] ) : '';
		$instance['exclude'] 		= ( ! empty( $new_instance['exclude'] ) ) ? $new_instance['exclude'] : array();
		$instance['include'] 		= ( ! empty( $new_instance['include'] ) ) ? $new_instance['include'] : array();

		return $instance;
	}

}