<?php

/*
	WPB Menu And Category Accordion
	By WPBean
	
*/

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 


if ( !class_exists('WPB_wcma_Settings_API' ) ):
class WPB_wcma_Settings_API {

    private $settings_api;

    function __construct() {
        $this->settings_api = new WPB_WMCA_WeDevs_Settings_API;

        add_action( 'admin_init', array($this, 'admin_init') );
        add_action( 'admin_menu', array($this, 'admin_menu') );
    }

    function admin_init() {

        //set the settings
        $this->settings_api->set_sections( $this->get_settings_sections() );
        $this->settings_api->set_fields( $this->get_settings_fields() );

        //initialize settings
        $this->settings_api->admin_init();
    }

    function admin_menu() {
        add_options_page( esc_html__( 'WPB Accordion Menu or Category','wpb-accordion-menu-or-category' ), esc_html__( 'WPB Accordion Menu or Category','wpb-accordion-menu-or-category' ), 'delete_posts', 'wpb_wcma_settings', array($this, 'wpb_wcma_plugin_option_page') );
    }

    function get_settings_sections() {
        $sections = array(
            array(
                'id'    => 'category_accordion',
                'title' => esc_html__( 'Category Accordion Settings', 'wpb-accordion-menu-or-category' )
            ),
            array(
                'id'    => 'menu_accordion',
                'title' => esc_html__( 'Menu Accordion Settings', 'wpb-accordion-menu-or-category' )
            ),
            array(
                'id'    => 'other_settings',
                'title' => esc_html__( 'Other Settings', 'wpb-accordion-menu-or-category' )
            ),
            array(
                'id'    => 'wpb_wamc_style_settings',
                'title' => esc_html__( 'Style Settings', 'wpb-accordion-menu-or-category' )
            )
        );

        $sections = apply_filters( 'wpb_wamc_settings_sections', $sections );

        return $sections;
    }

    /**
     * Returns all the settings fields
     *
     * @return array settings fields
     */
    function get_settings_fields() {
        $settings_fields = array(
            'category_accordion' => array(
                array(
                    'name'  => 'wpb_wmca_cat_icon_support',
                    'label' => esc_html__( 'Category Icon Support', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'No Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'    => 'wpb_wcma_icon_support_taxonomies',
                    'label'   => esc_html__( 'Taxonomy Icon Support', 'wpb-accordion-menu-or-category' ),
                    'desc'    => esc_html__( 'Choose taxonomies where you want icon support.', 'wpb-accordion-menu-or-category' ),
                    'type'    => 'multicheck',
                    'options' => get_taxonomies( array( 'public' => true ) ),
                ),
                array(
                    'name'  => 'wpb_wmca_cat_parent_open',
                    'label' => esc_html__( 'Keep 1st Level Parent Category Open', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_current_cat_open',
                    'label' => esc_html__( 'Keep Current Category Open', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_open_accordion_on_cat_click',
                    'label' => esc_html__( 'Open category accordion click on entire category.', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_show_desc_for_title',
                    'label' => esc_html__( 'Show description for category title.', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'    => 'wpb_wmca_cat_icon_type',
                    'label'   => esc_html__( 'Category icon type', 'wpb-accordion-menu-or-category' ),
                    'desc'    => esc_html__( 'Default icon font', 'wpb-accordion-menu-or-category' ),
                    'type'    => 'select',
                    'default' => 'font',
                    'options' => array(
                        'font'  => esc_html__( 'Font', 'wpb-accordion-menu-or-category' ),
                        'png'   => esc_html__( 'PNG', 'wpb-accordion-menu-or-category' ),
                    ),
                ),
            ),
            'menu_accordion' => array(

                array(
                    'name'  => 'wpb_wmca_menu_icon_support',
                    'label' => esc_html__( 'Menu Icon Support', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'No Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_menu_parent_open',
                    'label' => esc_html__( 'Keep 1st Level Parent Menu Open', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_current_menu_open',
                    'label' => esc_html__( 'Keep Current Menu Open', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),
                array(
                    'name'  => 'wpb_wmca_open_accordion_on_menu_click',
                    'label' => esc_html__( 'Open menu accordion click on entire menu item.', 'wpb-accordion-menu-or-category' ),
                    'desc'  => esc_html__( 'Yes Please!', 'wpb-accordion-menu-or-category' ),
                    'type'  => 'checkbox'
                ),

            ),
            'other_settings' => array(

                array(
                    'name'    => 'wpb_wmca_theme',
                    'label'   => esc_html__( 'Choose a Skin', 'wpb-accordion-menu-or-category' ),
                    'desc'    => esc_html__( 'Default Drak Skin', 'wpb-accordion-menu-or-category' ),
                    'type'    => 'select',
                    'default' => 'dark',
                    'options' => wpb_wmca_accordion_skins(),
                ),

                array(
                    'name'      => 'wpb_wmca_bg_color',
                    'label'     => esc_html__( 'Background Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#3b424d'
                ),

                array(
                    'name'      => 'wpb_wmca_bg_hover_color',
                    'label'     => esc_html__( 'Background Hover Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#383F4A'
                ),

                array(
                    'name'      => 'wpb_wmca_child_bg_color',
                    'label'     => esc_html__( 'Child Background Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#383838'
                ),

                array(
                    'name'      => 'wpb_wmca_child_bg_hover_color',
                    'label'     => esc_html__( 'Child Background Hover Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#383838'
                ),

                array(
                    'name'      => 'wpb_wmca_text_color',
                    'label'     => esc_html__( 'Text Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#f5f5f5'
                ),

                array(
                    'name'      => 'wpb_wmca_text_color_hover',
                    'label'     => esc_html__( 'Text Color Hover', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#f5f5f5'
                ),

                array(
                    'name'      => 'wpb_wmca_border_color',
                    'label'     => esc_html__( 'Border Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#414956'
                ),

                array(
                    'name'      => 'wpb_wmca_border_color_hover',
                    'label'     => esc_html__( 'Border Color Hover', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#414956'
                ),

                array(
                    'name'      => 'wpb_wmca_current_border_color',
                    'label'     => esc_html__( 'Current Item Border Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                ),

                array(
                    'name'      => 'wpb_wmca_current_color',
                    'label'     => esc_html__( 'Current Item Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                ),

                array(
                    'name'      => 'wpb_wmca_current_bg_color',
                    'label'     => esc_html__( 'Current Item Background Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                ),

                array(
                    'name'      => 'wpb_wmca_sub_menu_indicator_icon',
                    'label'     => esc_html__( 'Accordion open & close icon', 'wpb-accordion-menu-or-category' ),
                    'desc'      => esc_html__( 'You can set any font icon for the Accordion indicator. Add font icon class here.', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'text',
                    'default'   => 'fa fa-plus'
                ),
                array(
                    'name'      => 'wpb_wmca_indicator_open_rotate',
                    'label'     => esc_html__( 'Open Indicator Rotate', 'wpb-accordion-menu-or-category' ),
                    'desc'      => esc_html__( 'Sub menu or sub category indicator rotate when it\'s open. Default : 45 deg.', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'number',
                    'default'   => 45
                ),
                array(
                    'name'      => 'wpb_wmca_load_font_awesome',
                    'label'     => esc_html__( 'Load Font Awesome CSS', 'wpb-accordion-menu-or-category' ),
                    'desc'      => esc_html__( 'You can disable loading Font Awesome icon css form this plugin, if your theme or any other plugin loading this. Default Yes.', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'radio',
                    'default'   => 'yes',
                    'options'   => array(
                        'yes'   => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                        'no'    => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                    )
                ),
                array(
                    'name'      => 'wpb_wmca_load_themify_icons',
                    'label'     => esc_html__( 'Load Themify Icons', 'wpb-accordion-menu-or-category' ),
                    'desc'      => esc_html__( 'Default Yes.', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'radio',
                    'default'   => 'yes',
                    'options'   => array(
                        'yes'   => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                        'no'    => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                    )
                ),
                array(
                    'name'      => 'wpb_wmca_load_cookie',
                    'label'     => esc_html__( 'Load Font jQuery Cookie', 'wpb-accordion-menu-or-category' ),
                    'desc'      => esc_html__( 'You can disable loading jQuery Cookie form this plugin, if your theme or any other plugin loading this. Default Yes.', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'radio',
                    'default'   => 'yes',
                    'options'   => array(
                        'yes'   => esc_html__( 'Yes', 'wpb-accordion-menu-or-category' ),
                        'no'    => esc_html__( 'No', 'wpb-accordion-menu-or-category' ),
                    )
                ),
            ),
            'wpb_wamc_style_settings' => array(
                array(
                    'name'      => 'wpb_wmca_primary_color',
                    'label'     => esc_html__( 'Primary Color', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#d63031'
                ),
                array(
                    'name'      => 'wpb_wmca_primary_color_dark',
                    'label'     => esc_html__( 'Primary Color Dark', 'wpb-accordion-menu-or-category' ),
                    'type'      => 'color',
                    'default'   => '#c30000'
                ),

            ),
        );
        
        $settings_fields = apply_filters( 'wpb_wamc_settings_settings_fields', $settings_fields );

        return $settings_fields;
    }

    function wpb_wcma_plugin_option_page() {
        echo '<div class="wrap">';

        $this->settings_api->show_navigation();
        $this->settings_api->show_forms();

        echo '</div>';
    }

    /**
     * Get all the pages
     *
     * @return array page names with key value pairs
     */
    function get_pages() {
        $pages = get_pages();
        $pages_options = array();
        if ( $pages ) {
            foreach ($pages as $page) {
                $pages_options[$page->ID] = $page->post_title;
            }
        }

        return $pages_options;
    }

}
endif;

new WPB_wcma_Settings_API();