<?php
/*------------------------------------------------------------------------------
Plugin Name: PWF - WooCommerce Products Filter
Description: Filter WooCommerce products and WordPress post types. Filter by any criteria including categories, tags, taxonomies, price, and custom fields.
Plugin URI:  https://codecanyon.net/item/pwf-woocommerce-product-filters/28181010
Version:     1.9.8
uthor:       Mostafa
Author URI:  https://mostafaa.net/
License:     Codecanyon Split Licence
text domain: pwf-woo-filter
Domain Path: /languages
WC requires at least: 4.3.0
WC tested up to: 8.2.1
------------------------------------------------------------------------------*/

defined( 'ABSPATH' ) || exit; // exit if file is called directly

const PWF_WOO_FILTER_VER        = '1.9.8';
const PWF_WOO_FILTER_DB_VERSION = '1.0.1';

define( 'PWF_WOO_FILTER_URI', plugins_url( '', __FILE__ ) );
define( 'PWF_WOO_FILTER_DIR', plugin_dir_path( __FILE__ ) );
define( 'PWF_WOO_FILTER_DIR_DOMAIN', dirname( plugin_basename( __FILE__ ) ) );


require_once 'includes/classes/class-pwf-autoloader.php';
require_once 'includes/class-pwf-main.php';
require_once 'includes/widgets/class-pwf-filter-widget.php';
require_once 'includes/widgets/class-pwf-active-filters.php';
require_once 'includes/widgets/class-pwf-seo-short-description-widget.php';
require_once 'includes/render/class-pwf-render-filter.php';
require_once 'includes/class-pwf-front-end-ajax.php';
require_once 'includes/classes/api/class-pwf-api.php';

if ( ! is_admin() ) {
	require_once 'includes/classes/class-pwf-hook-wp-query.php';


	$enable_pretty_urls = get_option( 'pwf_shop_enable_pretty_links', 'enable' );
	if ( 'enable' === $enable_pretty_urls ) {
		require_once 'includes/classes/class-pwf-parse-request.php';
	}
}
if ( is_admin() && ! is_plugin_ajax() ) {
	require_once 'includes/classes/admin/class-pwf-admin-main.php';
	require_once 'includes/classes/admin/class-pwf-admin-settings-page.php';
}

/**
 * Checking if the URL request comes form frontfend Ajax.
 */
function is_plugin_ajax() {
	$is_ajax     = false;
	$post_action = $_POST['action'] ?? ''; //phpcs:ignore WordPress.Security.NonceVerification
	$get_action  = $_GET['action'] ?? ''; //phpcs:ignore WordPress.Security.NonceVerification
	if ( 'get_filter_result' === $post_action || 'get_filter_result' === $get_action ) {
		$is_ajax = true;
	}

	return apply_filters( 'is_plugin_ajax', $is_ajax );
}

// Add compitable to the Woo feature High-Performance Order Storage HPOS
add_action( 'before_woocommerce_init', 'add_compitable_hpos' );
function add_compitable_hpos() {
	if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
	}
}