<?php

defined( 'ABSPATH' ) || exit;

/*
 * @category 	Widgets
 * @extends 	WP_Widget
 * @since 1.8.0
 */

add_action( 'widgets_init', 'Pwf_Seo_Short_Description_Widget::register_widget' );

class Pwf_Seo_Short_Description_Widget extends WP_Widget {

	public function __construct() {

		$widget_ops = array(
			'classname'   => 'pwf-filter-seo-short-description',
			'description' => esc_html__( 'This widget displays an SEO short description.', 'pwf-woo-filter' ),
		);

		parent::__construct( 'pwf-filter-seo-short-description', 'PWF: ' . esc_html__( 'SEO Short Description', 'pwf-woo-filter' ), $widget_ops );
	}

	public static function register_widget() {
		register_widget( __class__ );
	}

	/**
	 * widget function.
	 *
	 * @see WP_Widget
	 * @access public
	 * @param array $args
	 * @param array $instance
	 * @return void
	 */
	public function widget( $args, $instance ) {
		if ( defined( 'REST_REQUEST' ) && REST_REQUEST ) {
			return '';
		}
		Pwf_Seo::seo_short_description();
	}

	public function form( $instance ) {
		return '';
	}
}
