<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Woocommerce_Single_Variations' ) ) {

	/**
	 * @since 1.6.6
	 */
	class Pwf_Woocommerce_Single_Variations {

		/**
		 * Integrate Filter with the plugin Woocommerce Single variations
		 *
		 * Making this plugin work we need to Edit filter settings and disable ajax
		 *
		 * Plugin URL https://welaunch.io/plugins/woocommerce-single-variations/
		 */

		/**
		 * Exclue filter IDs form working with this class
		 */
		protected static $exclude_filter_ids;

		/**
		 * check is excute we need to excute this query once
		 * The excute function is modify_product_query see class WooCommerce_Single_Variations_Public
		 *
		 * @since 1.6.6
		 */
		protected static $is_modify_product_query_excute;

		/**
		 * Plugin Woocommerce_Single_Variations options
		 * Hold the plugin options
		 *
		 * @since 1.6.6
		 */
		protected static $plugin_options;

		/**
		 * @see WooCommerce_Single_Variations_Public && function modify_product_query variables
		 */
		protected static $post__not_in;
		protected static $post_parent__not_in;

		public function __construct() {
			self::$post__not_in        = array();
			self::$post_parent__not_in = array();

			self::set_exclude_filter_ids();
			$this->init();
		}

		/**
		 * Allow developers to exclude some filters form working with this plugin
		 *
		 * @since 1.6.6
		 */
		protected static function set_exclude_filter_ids() {
			self::$exclude_filter_ids = apply_filters( 'pwf_exclude_filter_ids_from_working_with_woocommerce_single_variations', array() );
		}

		/**
		 * Check is a filter ID excluded
		 *
		 * @since 1.6.6
		 */
		protected static function is_filter_exclude( $filter_id ) {
			$is_exclude = false;

			if ( in_array( $filter_id, self::$exclude_filter_ids, true ) ) {
				$is_exclude = true;
			}

			return $is_exclude;
		}

		/**
		 * Get plugin Woocommerce Single Variations options
		 *
		 * @since 1.6.6
		 */
		protected static function get_option( $option_name ) {
			$result = '';

			$plugin_option_name = 'woocommerce_single_variations_options';

			if ( null === self::$plugin_options ) {
				self::$plugin_options = get_option( $plugin_option_name, '' );
				if ( empty( self::$plugin_options ) ) {
					self::$plugin_options = array();
				}
			}

			$result = self::$plugin_options[ $option_name ] ?? '';

			return $result;
		}

		/**
		 * Start class
		 *
		 * @since 1.6.6
		 */
		public function init() {
			add_filter( 'pwf_woo_post_type', array( $this, 'add_new_post_type' ), 10, 2 );

			// These filters are using with filter
			add_filter( 'pwf_woo_get_filter_term_product_counts_query', array( $this, 'customize_term_product_counts_query' ), 10, 2 );
			add_filter( 'pwf_woo_get_filter_term_product_sum_query', array( $this, 'customize_term_product_counts_query' ), 10, 2 );
			add_filter( 'pwf_woo_get_filter_author_product_counts_query', array( $this, 'customize_term_product_counts_query' ), 10, 2 );
			add_filter( 'pwf_woo_get_filter_stock_staus_product_counts_query', array( $this, 'customize_term_product_counts_query' ), 10, 2 );
			add_filter( 'pwf_woo_sub_query_for_posts', array( $this, 'customize_sub_query_for_posts' ), 10, 2 );
		}

		/**
		 * Change post type
		 *
		 * @param array $post_types
		 *
		 * @since 1.6.6
		 *
		 * @return array $post_types
		 */
		public function add_new_post_type( $post_types, $filter_id ) {
			if ( ! $this->is_filter_exclude( $filter_id ) ) {
				if ( in_array( 'product', $post_types, true ) ) {
					if ( ! in_array( 'product_variation', $post_types, true ) ) {
						array_push( $post_types, 'product_variation' );
					}
				}
			}

			return $post_types;
		}

		/**
		 * Set IDs for products that will be include and exclude from filters
		 * Most code from the function modify_product_query  the version is 1.0.0
		 *
		 * @see class WooCommerce_Single_Variations_Public && function modify_product_query
		 *
		 * @since 1.6.6
		 */
		protected function set_include_exclude_porduct_ids() {

			$post__not_in        = array();
			$post_parent__not_in = array();

			// @codingStandardsIgnoreStart
			$currentCategory = get_queried_object();

			$currentCategoryID = 0;

			if(isset($currentCategory->term_id)) {
				$currentCategoryID = $currentCategory->term_id;
			}
	
			$excludeProductCategories = $this->get_option('excludeProductCategories');
			if(!empty($excludeProductCategories) && in_array($currentCategoryID, $excludeProductCategories)) {
				return;
			}
	
			if($this->get_option('doNotShowVariationsOnFilter') && is_filtered()) {
				return;
			}
	
			if($this->get_option('onlyShowWhenFiltered') && !is_filtered() ) {
				return;
			}

			$excludeVariableProducts = $this->get_option('excludeVariableProducts');
			if( ! empty( $excludeVariableProducts ) ){
				// Our code
				$post_parent__not_in = $excludeVariableProducts;
			}

			$excludeVariationProducts = $this->get_option('excludeVariationProducts');
			if(!empty($excludeVariationProducts)){
				$post__not_in = $excludeVariationProducts;
			}

			// check code from line 287 to 472

			$includeVariationProducts = $this->get_option('includeVariationProducts');
			if(!empty($includeVariationProducts)) {
				$post__not_in = array_diff( $post__not_in, $includeVariationProducts );
			}

			// @codingStandardsIgnoreEnd

			/**
			 * These variables will be used with filters Query
			 */
			self::$post__not_in                   = $post__not_in;
			self::$post_parent__not_in            = $post_parent__not_in;
			self::$is_modify_product_query_excute = true;
		}

		/**
		 * Customize filter custom query
		 *
		 * @param array $query DB query
		 * @param int $filter_id
		 *
		 * @since 1.6.6
		 */
		public function customize_term_product_counts_query( $query, $filter_id ) {
			global $wpdb;

			if ( self::is_filter_exclude( $filter_id ) ) {
				return $query;
			}

			if ( ! self::$is_modify_product_query_excute ) {
				$this->set_include_exclude_porduct_ids();
			}

			if ( ! empty( self::$post__not_in ) || ! empty( self::$post_parent__not_in ) ) {
				if ( ! empty( self::$post__not_in ) ) {
					$query['where'] .= " AND {$wpdb->posts}.ID NOT IN (" . implode( ',', array_map( 'absint', self::$post__not_in ) ) . ')';
				}
				if ( ! empty( self::$post__not_in ) ) {
					$query['where'] .= " AND {$wpdb->posts}.post_parent NOT IN (" . implode( ',', array_map( 'absint', self::$post__not_in ) ) . ')';
				}
			}

			if ( $this->get_option( 'hideParentProducts' ) ) {
				$query['where'] .= " AND {$wpdb->posts}.ID NOT IN ( 
					SELECT DISTINCT {$wpdb->posts}.post_parent
					FROM {$wpdb->posts}
					WHERE {$wpdb->posts}.post_type = 'product_variation'
					)
				";
			}

			return $query;
		}

		/**
		 * Customize filter custom query
		 *
		 * @param string $sql DB query string
		 * @param int $filter_id
		 *
		 * @since 1.6.6
		 */
		public function customize_sub_query_for_posts( $sql, $filter_id ) {
			global $wpdb;

			if ( self::is_filter_exclude( $filter_id ) ) {
				return $sql;
			}

			if ( ! self::$is_modify_product_query_excute ) {
				$this->set_include_exclude_porduct_ids();
			}

			if ( ! empty( self::$post__not_in ) || ! empty( self::$post_parent__not_in ) ) {
				if ( ! empty( self::$post__not_in ) ) {
					$sql .= " AND {$wpdb->posts}.ID NOT IN (" . implode( ',', array_map( 'absint', self::$post__not_in ) ) . ')';
				}
				if ( ! empty( self::$post__not_in ) ) {
					$sql .= " AND {$wpdb->posts}.post_parent NOT IN (" . implode( ',', array_map( 'absint', self::$post__not_in ) ) . ')';
				}
			}

			if ( $this->get_option( 'hideParentProducts' ) ) {
				$sql .= " AND {$wpdb->posts}.ID NOT IN ( 
					SELECT DISTINCT {$wpdb->posts}.post_parent
					FROM {$wpdb->posts}
					WHERE {$wpdb->posts}.post_type = 'product_variation'
					)
				";
			}

			return $sql;
		}
	}
}
