<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Woo_Utilities' ) ) {

	/**
	 * Assign all WooCommerce functions at on place
	 *
	 * @since 1.6.6
	 */

	class Pwf_Woo_Utilities {

		public function __construct() {}

		/**
		 * Default Woocommerce shortcode attributes
		 * @see class Pwf_Integrate shortcode, parse_query_vars
		 *
		 * @since 1.5.4
		 *
		 * @return array $atts Default woocommerce shortcode attributes
		 */
		public static function get_woo_shortcode_default_attrs() {
			return array(
				'limit'          => '',
				'columns'        => '',
				'paginate'       => false,
				'skus'           => '',
				'ids'            => '',
				'on_sale'        => false,
				'best_selling'   => false,
				'top_rated'      => false,
				'category'       => '',
				'cat_operator'   => 'IN',
				'tag'            => '',
				'tag_operator'   => 'IN',
				'attribute'      => '',
				'terms'          => '',
				'terms_operator' => 'IN',
				'visibility'     => '',
				'order'          => '',
				'orderby'        => '',
			);
		}

		protected static function get_tax_query_out_of_stock() {
			return array(
				'taxonomy'         => 'product_visibility',
				'terms'            => array( 'outofstock' ),
				'field'            => 'slug',
				'operator'         => 'NOT IN',
				'include_children' => true,
			);
		}

		public static function get_product_visibility() {
			$exclude_from_catalog = array(
				'taxonomy'         => 'product_visibility',
				'terms'            => array( 'exclude-from-catalog' ),
				'field'            => 'slug',
				'operator'         => 'NOT IN',
				'include_children' => true,
			);

			$tax_query[] = $exclude_from_catalog;

			/*
			 * usefule when get products using ajax
			 */
			if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
				$tax_query[] = self::get_tax_query_out_of_stock();
			}

			return $tax_query;
		}

	}
}
