<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Yoast_Seo' ) ) {

	class Pwf_Yoast_Seo {

		public function __construct() {
			add_filter( 'wpseo_title', array( $this, 'modify_title_tag' ), 10, 1 );
			add_filter( 'wpseo_metadesc', array( $this, 'modify_meta_description' ), 10, 1 );
			add_filter( 'wpseo_opengraph_title', array( $this, 'modify_title_tag' ), 10, 1 );
			add_filter( 'wpseo_opengraph_desc', array( $this, 'modify_meta_description' ), 10, 1 );
			add_filter( 'wpseo_opengraph_url', array( $this, 'modify_canonical_url' ), 10, 1 );
			add_filter( 'wpseo_canonical', array( $this, 'modify_canonical_url' ), 10, 1 );
			add_filter( 'wpseo_adjacent_rel_url', array( $this, 'wpseo_adjacent_rel_url' ), 10, 2 );
			add_filter( 'wpseo_breadcrumb_links', array( $this, 'wpseo_breadcrumb_links' ), 10, 1 );
		}

		/**
		 * Modify Title tag & meta og:title
		 */
		public function modify_title_tag( $title ) {
			return Pwf_Seo::get_title_tag_rewrite_rule( $title );
		}

		/**
		 * Modify meta description & meta og:description
		 */
		public function modify_meta_description( $description ) {
			return Pwf_Seo::get_meta_description_rewrite_rule( $description );
		}

		public function modify_canonical_url( $url ) {
			return Pwf_Seo::canonical_url( $url );
		}

		/**
		 * Modify Prev & next Link
		 *
		 * @param string $url string $rel_next or $rel_prev The rel next or next URL.
		 * @param string $rel Link relationship, prev or next.
		 *
		 * @return string $url
		 */
		public function wpseo_adjacent_rel_url( $url, $rel ) {
			if ( empty( $url ) ) {
				return $url;
			}
			if ( 'prev' === $rel || 'next' === $rel ) {
				$url = Pwf_Seo::generate_canoncial_url( $url );
			}

			return $url;
		}

		public function wpseo_breadcrumb_links( $links ) {
			$breadcumbs = Pwf_Seo::get_breadcumbs();
			if ( ! empty( $breadcumbs ) ) {
				$links[] = array(
					'url'  => Pwf_Seo::get_breadcumbs_url(),
					'text' => esc_html( $breadcumbs ),
				);
			}

			return $links;
		}
	}
}
