<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Squirrly_Seo' ) ) {

	class Pwf_Squirrly_Seo {

		public function __construct() {
			add_filter( 'sq_title', array( $this, 'modify_title_tag' ), 11, 1 );
			add_filter( 'sq_description', array( $this, 'modify_meta_description' ), 11, 1 );
			add_filter( 'sq_canonical', array( $this, 'modify_canonical_url' ), 11, 1 );
			add_filter( 'sq_open_graph', array( $this, 'modify_open_graph' ), 11, 1 );
			add_filter( 'sq_twitter_card', array( $this, 'modify_twitter_card' ), 11, 1 );
			/**
			 * Can't modify prev/next link
			 * add_filter( 'sq_noindex', array( $this, 'modify_prev_next_rel_link' ), 100, 1 );
			 * add_filter( 'sq_buffer', array( $this, 'prev_next'), 10, 1 );
			 */
		}

		/**
		 * Modify Title tag & meta og:title
		 */
		public function modify_title_tag( $title ) {
			return Pwf_Seo::get_title_tag_rewrite_rule( $title );
		}

		/**
		 * Modify meta description & meta og:description
		 */
		public function modify_meta_description( $description ) {
			return Pwf_Seo::get_meta_description_rewrite_rule( $description );
		}

		public function modify_canonical_url( $url ) {
			return Pwf_Seo::canonical_url( $url );
		}

		/**
		 * FaceBook.
		 *
		 * @param array $og. For example og['og:url'] => 'title'
		 *
		 * @return array $og after modify
		 */
		public function modify_open_graph( $og ) {
			$og['og:url']         = Pwf_Seo::canonical_url( $og['og:url'] );
			$og['og:title']       = Pwf_Seo::get_title_tag_rewrite_rule( $og['og:title'] );
			$og['og:description'] = Pwf_Seo::get_meta_description_rewrite_rule( $og['og:description'] );

			return $og;
		}

		/**
		 * Twitter Card.
		 *
		 * @param array $tc. For example og['og:url'] => 'title'
		 *
		 * @return array $tc after modify
		 */
		public function modify_twitter_card( $tc ) {
			$tc['twitter:url']         = Pwf_Seo::canonical_url( $tc['twitter:url'] );
			$tc['twitter:title']       = Pwf_Seo::get_title_tag_rewrite_rule( $tc['twitter:title'] );
			$tc['twitter:description'] = Pwf_Seo::get_meta_description_rewrite_rule( $tc['twitter:description'] );

			return $tc;
		}
	}
}
