<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Seo_Press' ) ) {

	class Pwf_Seo_Press {

		public function __construct() {
			add_filter( 'seopress_titles_title', array( $this, 'modify_title_tag' ), 10, 1 );
			add_filter( 'seopress_titles_desc', array( $this, 'modify_meta_description' ), 10, 1 );
			add_filter( 'seopress_titles_canonical', array( $this, 'modify_canonical_url' ), 10, 1 );
			add_filter( 'seopress_social_og_url', array( $this, 'og_url' ), 10, 1 );

			add_action( 'wp_head', array( $this, 'remove_prev_next_rel_link' ), 5 );
			add_action( 'wp_head', array( $this, 'modify_prev_next_rel_link' ), 10 );
			/**
			 * require Premium
			 * $param array
			 * add_filter( 'seopress_pro_breadcrumbs_crumbs', array( $this, 'breadcrumbs' ), 10, 1 );
			 */
		}

		/**
		 * Remove Plugin action hooks
		 */
		public function remove_prev_next_rel_link() {
			remove_action( 'wp_head', 'seopress_titles_paged_rel_hook', 9 );
		}

		/**
		 * Modify Title tag & meta og:title
		 */
		public function modify_title_tag( $title ) {
			return Pwf_Seo::get_title_tag_rewrite_rule( $title );
		}

		/**
		 * Modify meta description & meta og:description
		 */
		public function modify_meta_description( $description ) {
			return Pwf_Seo::get_meta_description_rewrite_rule( $description );
		}

		public function modify_canonical_url( $html_url ) {
			$pattern = '/(?<=href\=")[^]]+?(?=")/';
			preg_match_all( $pattern, $html_url, $matches );

			if ( isset( $matches[0][0] ) && ! empty( $matches[0][0] ) ) {
				$url      = Pwf_Seo::canonical_url( $matches[0][0] );
				$html_url = '<link rel="canonical" href="' . htmlspecialchars( urldecode( $url ) ) . '" />';
			}

			return $html_url;
		}

		/**
		 * @param string $html
		 */
		public function og_title( $html ) {
			$title = Pwf_Seo::get_title_tag_rewrite_rule( '' );
			$html  = '<meta property="og:title" content="' . esc_attr( $title ) . '" />';

			return $html;
		}

		/**
		 * @param string $html link
		 */
		public function og_url( $html ) {
			$pattern = '/(?<=content\=")[^]]+?(?=")/';
			preg_match_all( $pattern, $html, $matches );

			if ( isset( $matches[0][0] ) && ! empty( $matches[0][0] ) ) {
				$url  = Pwf_Seo::get_canonical_url( $matches[0][0] );
				$html = '<meta property="og:url" content="' . htmlspecialchars( urldecode( $url ), ENT_COMPAT, 'UTF-8' ) . '" />';
			}

			return $html;
		}

		/**
		 * Add Prev & next Link
		 *
		 * @return string $link
		 */
		public function modify_prev_next_rel_link() {
			global $paged;

			if ( get_previous_posts_link() ) {
				$url = get_pagenum_link( $paged - 1 );
				$url = Pwf_Seo::generate_canoncial_url( $url );
				echo '<link rel="prev" href="' . esc_url( $url ) . '" />';
			}
			if ( get_next_posts_link() ) {
				$url = get_pagenum_link( $paged + 1 );
				$url = Pwf_Seo::generate_canoncial_url( $url );
				echo '<link rel="next" href="' . esc_url( $url ) . '" />';
			}
		}
	}
}
