<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Rank_Math' ) ) {

	class Pwf_Rank_Math {

		public function __construct() {
			add_filter( 'rank_math/frontend/title', array( $this, 'modify_title_tag' ), 10, 1 );
			add_filter( 'rank_math/frontend/description', array( $this, 'modify_meta_description' ), 10, 1 );
			add_filter( 'rank_math/frontend/canonical', array( $this, 'modify_canonical_url' ), 10, 1 );
			add_filter( 'rank_math/frontend/prev_rel_link', array( $this, 'modify_prev_next_rel_link' ), 10, 1 );
			add_filter( 'rank_math/frontend/next_rel_link', array( $this, 'modify_prev_next_rel_link' ), 10, 1 );
			add_filter( 'rank_math/frontend/breadcrumb/items', array( $this, 'breadcrumbs' ), 10, 2 );
		}

		/**
		 * Modify Title tag & meta og:title
		 */
		public function modify_title_tag( $title ) {
			return Pwf_Seo::get_title_tag_rewrite_rule( $title );
		}

		/**
		 * Modify meta description & meta og:description
		 */
		public function modify_meta_description( $description ) {
			return Pwf_Seo::get_meta_description_rewrite_rule( $description );
		}

		public function modify_canonical_url( $url ) {
			return Pwf_Seo::canonical_url( $url );
		}

		/**
		 * Modify Prev & next Link
		 *
		 * @param string The full `<link` element.
		 *
		 * @return string $link
		 */
		public function modify_prev_next_rel_link( $link ) {
			if ( ! empty( $link ) ) {
				$pattern = '/(?<=href\=")[^]]+?(?=")/';
				preg_match_all( $pattern, $link, $matches );
				$url  = Pwf_Seo::generate_canoncial_url( $matches[0][0] );
				$link = preg_replace( $pattern, $url, $link );
			}

			return $link;
		}

		public function breadcrumbs( $crumbs, $class ) {
			$has_page_num = false;
			$breadcumbs   = Pwf_Seo::get_breadcumbs();
			if ( ! empty( $breadcumbs ) ) {
				$position = count( $crumbs );
				if ( $position > 1 ) {
					--$position;
					if ( strpos( strtolower( $crumbs[ $position ][0] ), 'page' ) !== false ) {
						$has_page_num = true;
					}
				}

				$breadcumb_item = array(
					$breadcumbs,
					Pwf_Seo::get_breadcumbs_url(),
					'hide_in_schema' => '',
				);

				if ( $has_page_num ) {
					$crumbs = array_merge( array_slice( $crumbs, 0, $position ), array( $breadcumb_item ), array_slice( $crumbs, $position ) );

				} else {
					$crumbs[] = $breadcumb_item;
				}
			}
			return $crumbs;
		}
	}
}
