<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_All_In_One_Seo' ) ) {

	class Pwf_All_In_One_Seo {

		public function __construct() {
			// Modify Title tag & og:title & twitter:title
			add_filter( 'aioseo_title', array( $this, 'modify_title_tag' ), 10, 1 );
			// Modify meta description & og:description
			add_filter( 'aioseo_description', array( $this, 'modify_meta_description' ), 10, 1 );
			// Modify canonical & og:url
			add_filter( 'aioseo_canonical_url', array( $this, 'modify_canonical_url' ), 10, 1 );
			add_filter( 'aioseo_next_link', array( $this, 'modify_prev_next_rel_link' ), 10, 1 );
			add_filter( 'aioseo_prev_link', array( $this, 'modify_prev_next_rel_link' ), 10, 1 );
			add_filter( 'aioseo_breadcrumbs_trail', array( $this, 'breadcrumbs' ), 10, 1 );
			// prev && next &breacumbs
		}

		/**
		 * Modify Title tag & meta og:title
		 */
		public function modify_title_tag( $title ) {
			return Pwf_Seo::get_title_tag_rewrite_rule( $title );
		}

		/**
		 * Modify meta description & meta og:description
		 */
		public function modify_meta_description( $description ) {
			return Pwf_Seo::get_meta_description_rewrite_rule( $description );
		}

		public function modify_canonical_url( $url ) {
			return Pwf_Seo::canonical_url( $url );
		}

		/**
		 * Modify Prev & next Link
		 *
		 * @param string $url.
		 *
		 * @return string $url
		 */
		public function modify_prev_next_rel_link( $url ) {
			if ( ! empty( $url ) ) {
				$url = Pwf_Seo::generate_canoncial_url( $url );
			}

			return $url;
		}

		public function breadcrumbs( $crumbs ) {
			$has_page_num = false;
			$breadcumbs   = Pwf_Seo::get_breadcumbs();
			if ( ! empty( $breadcumbs ) ) {
				$position = count( $crumbs );
				if ( $position > 1 ) {
					--$position;
					if ( strpos( strtolower( $crumbs[ $position ]['label'] ), 'page' ) !== false ) {
						$has_page_num = true;
					}
				}

				$breadcumb_item = array(
					'label'   => $breadcumbs,
					'link'    => Pwf_Seo::get_breadcumbs_url(),
					'type'    => 'pwf',
					'subType' => '',
				);

				if ( $has_page_num ) {
					$crumbs = array_merge( array_slice( $crumbs, 0, $position ), array( $breadcumb_item ), array_slice( $crumbs, $position ) );

				} else {
					$crumbs[] = $breadcumb_item;
				}
			}

			return $crumbs;
		}
	}
}
