<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Customizer' ) ) {

	class Pwf_Customizer {

		public function __construct( $wp_customize ) {
			$this->init( $wp_customize );
		}

		public static function is_numeric( $value, $setting ) {
			if ( is_numeric( $value ) ) {
				return $value;
			} else {
				return '';
			}
		}

		private function init( $wp_customize ) {

			$wp_customize->add_panel(
				'pwf_plugin_options',
				array(
					'priority'    => 200,
					'capability'  => 'edit_theme_options',
					'title'       => esc_html__( 'PWF Filter Options', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Theme Modifications like color scheme, theme texts and layout preferences can be done here', 'pwf-woo-filter' ),
				)
			);

			$sections = self::get_sections();

			foreach ( $sections as $key_section => $section ) {

				$args_section = array(
					'panel'      => 'pwf_plugin_options',
					'title'      => $section['section']['title'],
					'capability' => 'edit_theme_options',
				);
				if ( isset( $section['section']['description'] ) ) {
					$args_section['description'] = $section['section']['description'];
				}
				$wp_customize->add_section( $key_section, $args_section );

				$settings = $section['settings'];

				foreach ( $settings as $key => $setting ) {
					$args_setting = array(
						'default'   => $setting['default'],
						'transport' => 'postMessage',
						'type'      => 'option',
					);

					if ( isset( $setting['transport'] ) ) {
						$args_setting['transport'] = $setting['transport'];
					}

					if ( isset( $setting['sanitize_callback'] ) ) {
						$args_setting['sanitize_callback'] = $setting['sanitize_callback'];
					} else {
						if ( ! isset( $setting['type'] ) ) {
							$args_setting['sanitize_callback'] = 'sanitize_hex_color';
						} else {
							$args_setting['sanitize_callback'] = 'absint';
						}
					}

					$args_control = array(
						'label'    => $setting['label'],
						'section'  => $key_section,
						'settings' => $key,
					);
					if ( isset( $setting['description'] ) ) {
						$args_control['description'] = $setting['description'];
					}
					if ( isset( $setting['type'] ) ) {
						$args_control['type'] = $setting['type'];
					}
					if ( isset( $setting['choices'] ) ) {
						$args_control['choices'] = $setting['choices'];
					}

					if ( isset( $setting['input_attrs'] ) ) {
						$args_control['input_attrs'] = $setting['input_attrs'];
					} elseif ( isset( $setting['type'] ) && 'number' === $setting['type'] ) {
						$args_control['input_attrs'] = array(
							'min' => 1,
							'max' => 100,
						);
					}

					$wp_customize->add_setting( $key, $args_setting );

					if ( ! isset( $setting['type'] ) ) {
						$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, $key, $args_control ) );
					} else {
						$wp_customize->add_control( new WP_Customize_Control( $wp_customize, $key, $args_control ) );
					}
				}
			}
		}

		public static function get_sections() {
			$sections = array(
				'pwf_general_options' => array(
					/**
					 * General
					 */
					'section'  => array(
						'title' => esc_html__( 'General', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[filter_bg]' => array(
							'default' => '',
							'label'   => esc_html__( 'Filter Background', 'pwf-woo-filter' ),
						),
					),
				),
				/**
				 * Item Title
				 */
				'pwf_item_title'      => array(
					'section'  => array(
						'title' => esc_html__( 'Item title', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[title_color]'          => array(
							'default' => '#222',
							'label'   => esc_html__( 'Title color', 'pwf-woo-filter' ),
						),
						'pwf_style[title_font_size]'      => array(
							'default' => 15,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[title_font_weight]'    => array(
							'default' => 600,
							'type'    => 'select',
							'label'   => self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[title_margin_bottom]'  => array(
							'default' => 16,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'margin-bottom' ),
						),
						'pwf_style[title_border_status]'  => array(
							'default'           => 'off',
							'type'              => 'select',
							'label'             => esc_html__( 'Title border bottom', 'pwf-woo-filter' ),
							'sanitize_callback' => 'sanitize_key',
							'choices'           => array(
								'on'  => 'On',
								'off' => 'Off',
							),
						),
						'pwf_style[title_padding_bottom]' => array(
							'default'     => '',
							'type'        => 'number',
							'label'       => esc_html__( 'Padding bottom', 'pwf-woo-filter' ),
							'description' => esc_html__( 'useful if you plan to use the border.', 'pwf-woo-filter' ),
						),
						'pwf_style[title_border_color]'   => array(
							'default' => '',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[title_border_width]'   => array(
							'default' => 1,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
					),
				),
				/**
				 * Active Product Filters
				 */
				'pwf_active_filters'  => array(
					'section'  => array(
						'title' => esc_html__( 'Active Product Filters', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[af_font_size]'          => array(
							'default' => 14,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[af_line_height]'        => array(
							'default' => 20,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'line-height' ),
						),
						'pwf_style[af_border_width]'       => array(
							'default' => 1,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
						'pwf_style[af_border_radius]'      => array(
							'default' => 8,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[af_text_color]'         => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[_af_bg_color]'          => array(
							'default' => '#f2f2f2',
							'label'   => self::get_translated_text( 'background-color' ),
						),
						'pwf_style[af_border_color]'       => array(
							'default' => '#e5e5e5',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[af_text_hover_color]'   => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-hover-color' ),
						),
						'pwf_style[af_bg_hover_color]'     => array(
							'default' => '#e5e5e5',
							'label'   => self::get_translated_text( 'background-hover-color' ),
						),
						'pwf_style[af_border_hover_color]' => array(
							'default' => '#e5e5e5',
							'label'   => self::get_translated_text( 'border-hover-color' ),
						),
					),
				),
				/**
				 * Boxlist
				 */
				'pwf_boxlist_item'    => array(
					'section'  => array(
						'title' => esc_html__( 'Box list', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[boxlist_margin]'        => array(
							'default'     => 12,
							'type'        => 'number',
							'label'       => esc_html__( 'Margin', 'pwf-woo-filter' ),
							'description' => esc_html__( 'Margin between options.', 'pwf-woo-filter' ),
						),
						'pwf_style[boxlist_font_size]'     => array(
							'default' => 15,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[boxlist_font_weight]'   => array(
							'default' => 400,
							'type'    => 'select',
							'label'   => self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[boxlist_border_width]'  => array(
							'default' => 1,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
						'pwf_style[boxlist_border_radius]' => array(
							'default' => 0,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[boxlist_text_color]'    => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[boxlist_text_hover_color]' => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'text-hover-color' ),
						),
						'pwf_style[boxlist_bg_color]'      => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-color' ),
						),
						'pwf_style[boxlist_bg_hover_color]' => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'background-hover-color' ),
						),
						'pwf_style[boxlist_border_color]'  => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[boxlist_border_hover_color]' => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'border-hover-color' ),
						),
						'pwf_style[boxlist_count_font_size]' => array(
							'default' => 11,
							'type'    => 'number',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-size' ),
						),
						'pwf_style[boxlist_count_font_weight]' => array(
							'default' => 500,
							'type'    => 'select',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[boxlist_count_text_color]' => array(
							'default' => '#777',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'text-color' ),
						),
						'pwf_style[boxlist_count_text_hover_color]' => array(
							'default' => '#FFF',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'text-hover-color' ),
						),
						'pwf_style[boxlist_count_bg_color]' => array(
							'default' => '#f1f1f1',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'background-color' ),
						),
						'pwf_style[boxlist_count_hover_bg_color]' => array(
							'default' => '',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'background-color' ),
						),
					),
				),
				/**
				 * Button
				 */
				'pwf_button'          => array(
					'section'  => array(
						'title' => esc_html__( 'Button', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[button_font_size]'      => array(
							'default' => 15,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[button_font_weight]'    => array(
							'default' => 600,
							'type'    => 'select',
							'label'   => self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[button_border_radius]'  => array(
							'default' => 2,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[button_color]'          => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[button_bg_color]'       => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-color' ),
						),
						'pwf_style[button_border_color]'   => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[button_hover_color]'    => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-hover-color' ),
						),
						'pwf_style[button_bg_hover_color]' => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-hover-color' ),
						),
						'pwf_style[button_border_hover_color]' => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'border-hover-color' ),
						),
					),
				),
				/**
				 * ColorList
				 */
				'pwf_colorlist_item'  => array(
					'section'  => array(
						'title' => esc_html__( 'Color list', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[colorlist_margin]' => array(
							'default'     => 12,
							'type'        => 'number',
							'label'       => esc_html__( 'Margin', 'pwf-woo-filter' ),
							'description' => esc_html__( 'Margin between options.', 'pwf-woo-filter' ),
						),
						'pwf_style[colorlist_count_font_size]' => array(
							'default' => 11,
							'type'    => 'number',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-size' ),
						),
						'pwf_style[colorlist_count_font_weight]' => array(
							'default' => 500,
							'type'    => 'select',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[colorlist_count_text_color]' => array(
							'default' => '#222',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'text-color' ),
						),
						'pwf_style[colorlist_count_bg_color]' => array(
							'default' => '#F1F1F1',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'background-color' ),
						),
					),
				),
				/**
				 * Range Slider
				 */
				'pwf_range_slider'    => array(
					'section'  => array(
						'title' => esc_html__( 'Range Slider', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[slider_line_height]'   => array(
							'default' => 3,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'line-height' ),
						),
						'pwf_style[slider_handle_width]'  => array(
							'default' => 16,
							'type'    => 'number',
							'label'   => esc_html__( 'Handle width', 'pwf-woo-filter' ),
						),
						'pwf_style[slider_handle_height]' => array(
							'default' => 16,
							'type'    => 'number',
							'label'   => esc_html__( 'Handle height', 'pwf-woo-filter' ),
						),
						'pwf_style[slider_handle_top]'    => array(
							'default'           => -8,
							'type'              => 'number',
							'label'             => esc_html__( 'Handle top', 'pwf-woo-filter' ),
							'sanitize_callback' => 'Pwf_Customizer::is_numeric',
							'input_attrs'       => array(
								'min' => -100,
								'max' => 100,
							),
						),
						'pwf_style[slider_handle_border_width]' => array(
							'default' => 4,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
						'pwf_style[slider_handle_border_radius]' => array(
							'default' => 100,
							'type'    => 'number',
							'label'   => esc_html__( 'Handle border radius', 'pwf-woo-filter' ),
						),
						'pwf_style[slider_handle_bg_color]' => array(
							'default' => '#222',
							'label'   => esc_html__( 'Handle background Color', 'pwf-woo-filter' ),
						),
						'pwf_style[slider_handle_border_color]' => array(
							'default' => '#FFF',
							'label'   => esc_html__( 'Handle border Color', 'pwf-woo-filter' ),
						),
						'pwf_style[slider_label_color]'   => array(
							'default' => '#666',
							'label'   => esc_html__( 'Label color', 'pwf-woo-filter' ),
						),
					),
				),
				/**
				 * Search item
				 */
				'pwf_search'          => array(
					'section'  => array(
						'title' => esc_html__( 'Search', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[search_icon_color]' => array(
							'default' => '#666',
							'label'   => esc_html__( 'Search Icon color', 'pwf-woo-filter' ),
						),
					),
				),

				/**
				 * SELECT
				 */
				'pwf_select'          => array(
					'section'  => array(
						'title' => esc_html__( 'Select', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[select_font_size]'    => array(
							'default' => 15,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[select_font_weight]'  => array(
							'default' => 400,
							'type'    => 'select',
							'label'   => self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[select_height]'       => array(
							'default' => 36,
							'type'    => 'number',
							'label'   => esc_html__( 'height', 'pwf-woo-filter' ),
						),
						'pwf_style[select_color]'        => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[select_border_color]' => array(
							'default' => '',
							'label'   => self::get_translated_text( 'border-color' ),
						),
					),
				),
				/**
				 * Text Input
				 */
				'pwf_input_text'      => array(
					'section'  => array(
						'title'       => esc_html__( 'Text Input', 'pwf-woo-filter' ),
						'description' => esc_html__( 'These options are used in filter item date, range slider, and search.', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[input_font_size]'     => array(
							'default' => 13,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[input_height]'        => array(
							'default' => 36,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'line-height' ),
						),
						'pwf_style[input_border_radius]' => array(
							'default' => 0,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[input_text_color]'    => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[input_border_color]'  => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-color' ),
						),
					),
				),
				/**
				 * Group Checkbox, Radio, Textlist
				 */
				'pwf_group_items'     => array(
					'section'  => array(
						'title' => esc_html__( 'Global - Checkbox, Radio, Text list', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[group_items_margin_bottom]' => array(
							'default'     => 8,
							'type'        => 'number',
							'label'       => self::get_translated_text( 'margin-bottom' ),
							'description' => esc_html__( 'Margin bottom between options.', 'pwf-woo-filter' ),
						),
						'pwf_style[group_items_font_size]' => array(
							'default' => 15,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'font-size' ),
						),
						'pwf_style[group_items_line_height]' => array(
							'default' => 21,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'line-height' ),
						),
						'pwf_style[group_items_font_weight]' => array(
							'default' => 400,
							'type'    => 'select',
							'label'   => self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[group_items_text_color]' => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-color' ),
						),
						'pwf_style[group_items_text_hover_color]' => array(
							'default' => '#222',
							'label'   => self::get_translated_text( 'text-hover-color' ),
						),
						'pwf_style[group_items_count_font_size]' => array(
							'default' => 13,
							'type'    => 'number',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-size' ),
						),
						'pwf_style[group_items_count_font_weight]' => array(
							'default' => 400,
							'type'    => 'select',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'font-weight' ),
							'choices' => self::get_font_weight(),
						),
						'pwf_style[group_items_count_text_color]' => array(
							'default' => '#777',
							'label'   => esc_html__( 'Count', 'pwf-woo-filter' ) . ' ' . self::get_translated_text( 'text-color' ),
						),
					),
				),
				/**
				 * Checkbox
				 */
				'pwf_checkbox_item'   => array(
					'section'  => array(
						'title' => esc_html__( 'Checkbox List', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[checkbox_size]'         => array(
							'default' => 18,
							'type'    => 'number',
							'label'   => esc_html__( 'Square size', 'pwf-woo-filter' ),
						),
						'pwf_style[checkbox_border_width]' => array(
							'default' => 1,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
						'pwf_style[checkbox_border_radius]' => array(
							'default' => 2,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[checkbox_bg_color]'     => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-color' ),
						),
						'pwf_style[checkbox_bg_hover_color]' => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-hover-color' ),
						),
						'pwf_style[checkbox_border_color]' => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[checkbox_border_hover_color]' => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-hover-color' ),
						),
						'pwf_style[checkbox_mark_color]'   => array(
							'default' => '#222',
							'label'   => esc_html__( 'Mark color', 'pwf-woo-filter' ),
						),
						'pwf_style[checkbox_mark_width]'   => array(
							'default' => 9,
							'type'    => 'number',
							'label'   => esc_html__( 'Mark width', 'pwf-woo-filter' ),
						),
						'pwf_style[checkbox_mark_height]'  => array(
							'default' => 4,
							'type'    => 'number',
							'label'   => esc_html__( 'Mark height', 'pwf-woo-filter' ),
						),
						'pwf_style[checkbox_mark_top_position]' => array(
							'default'           => 3,
							'type'              => 'number',
							'label'             => esc_html__( 'Mark top position', 'pwf-woo-filter' ),
							'sanitize_callback' => 'Pwf_Customizer::is_numeric',
							'input_attrs'       => array(
								'min' => -100,
								'max' => 100,
							),
						),
						'pwf_style[checkbox_mark_left_position]' => array(
							'default'           => 3,
							'type'              => 'number',
							'label'             => esc_html__( 'Mark left position', 'pwf-woo-filter' ),
							'sanitize_callback' => 'Pwf_Customizer::is_numeric',
							'input_attrs'       => array(
								'min' => -100,
								'max' => 100,
							),
						),
					),
				),
				/**
				 * ٌRadio
				 */
				'pwf_radio_item'      => array(
					'section'  => array(
						'title' => esc_html__( 'Radio List', 'pwf-woo-filter' ),
					),
					'settings' => array(
						'pwf_style[radio_size]'           => array(
							'default' => 18,
							'type'    => 'number',
							'label'   => esc_html__( 'Circular size', 'pwf-woo-filter' ),
						),
						'pwf_style[radio_border_width]'   => array(
							'default' => 1,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-width' ),
						),
						'pwf_style[radio_border_radius]'  => array(
							'default' => 100,
							'type'    => 'number',
							'label'   => self::get_translated_text( 'border-radius' ),
						),
						'pwf_style[radio_bg_color]'       => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-color' ),
						),
						'pwf_style[radio_bg_hover_color]' => array(
							'default' => '#FFF',
							'label'   => self::get_translated_text( 'background-hover-color' ),
						),
						'pwf_style[radio_border_color]'   => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-color' ),
						),
						'pwf_style[radio_border_hover_color]' => array(
							'default' => '#d4d4d4',
							'label'   => self::get_translated_text( 'border-hover-color' ),
						),
						'pwf_style[radio_mark_color]'     => array(
							'default' => '#222',
							'label'   => esc_html__( 'Mark color', 'pwf-woo-filter' ),
						),
						'pwf_style[radio_mark_width]'     => array(
							'default' => 60,
							'type'    => 'number',
							'label'   => esc_html__( 'Mark width', 'pwf-woo-filter' ),
						),
						'pwf_style[radio_mark_height]'    => array(
							'default' => 60,
							'type'    => 'number',
							'label'   => esc_html__( 'Mark height', 'pwf-woo-filter' ),
						),
						'pwf_style[radio_mark_top_position]' => array(
							'default'           => 20,
							'type'              => 'number',
							'label'             => esc_html__( 'Mark top position', 'pwf-woo-filter' ),
							'sanitize_callback' => 'Pwf_Customizer::is_numeric',
							'input_attrs'       => array(
								'min' => -100,
								'max' => 100,
							),
						),
						'pwf_style[radio_mark_left_position]' => array(
							'default'           => 20,
							'type'              => 'number',
							'label'             => esc_html__( 'Mark left position', 'pwf-woo-filter' ),
							'sanitize_callback' => 'Pwf_Customizer::is_numeric',
							'input_attrs'       => array(
								'min' => -100,
								'max' => 100,
							),
						),
					),
				),
			);

			return $sections;
		}
		protected static function get_translated_text( $slug ) {
			$translated_text = array(
				'border-color'           => esc_html__( 'Border color', 'pwf-woo-filter' ),
				'border-hover-color'     => esc_html__( 'Border Hover color', 'pwf-woo-filter' ),
				'background-color'       => esc_html__( 'Background color', 'pwf-woo-filter' ),
				'background-hover-color' => esc_html__( 'Background hover color', 'pwf-woo-filter' ),
				'border-radius'          => esc_html__( 'Border radius', 'pwf-woo-filter' ),
				'font-size'              => esc_html__( 'Font size', 'pwf-woo-filter' ),
				'font-weight'            => esc_html__( 'Font weight', 'pwf-woo-filter' ),
				'border-width'           => esc_html__( 'Border width', 'pwf-woo-filter' ),
				'margin-bottom'          => esc_html__( 'Margin bottom', 'pwf-woo-filter' ),
				'line-height'            => esc_html__( 'Line height', 'pwf-woo-filter' ),
				'text-color'             => esc_html__( 'Text color', 'pwf-woo-filter' ),
				'text-hover-color'       => esc_html__( 'Text hover color', 'pwf-woo-filter' ),
			);

			return $translated_text[ $slug ];
		}
		protected static function get_font_weight() {
			return array(
				100 => 100,
				200 => 200,
				300 => 300,
				400 => 400,
				500 => 500,
				600 => 600,
				700 => 700,
				800 => 800,
				900 => 900,
			);
		}
	}
}
