<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Seo_Templates' ) ) {
	/**
	 * HTML templates used on SEO Setting Page
	 *
	 */
	class Pwf_Seo_Templates {

		public function __construct() {}

		public static function start_render_page() {
			echo '<div class="wrap"><div class="pwf-layout pwf-seo-direction">';
			echo '<div id="pwf-seo-header" class="pwf-layout__header">';
			echo '<h1 class="pwf-layout__header-heading wp-heading-inline">' . esc_html__( 'SEO Rules', 'pwf-woo-filter' ) . '</h1>';
			self::add_page_rule_link();
			echo '<button class="generate-xml-sitemap page-title-action save-seo-options">' . esc_html__( 'Save Changes', 'pwf-woo-filter' ) . '</button>';
			self::generate_site_map_btn();
			echo '</div>';
			echo '<hr class="wp-header-end">';
			if ( ! self::is_plugin_activated() ) {
				echo '<div class="notice notice-warning"><p><strong>';
				echo esc_html__( 'Add the purchase code to unlock the SEO feature on the front-end.', 'pwf-woo-filter' );
				echo '</strong></p></div>';
			}
			echo '<div class="pwf-error-message"></div>';
			echo '<div class="pwf-settings-content pro-woo-filter">';
			echo '<div id="poststuff">';
			echo '<div class="seo-page-content panel-group meta-box-sortables">';
		}

		public static function end_render_page() {
			echo '<input type="submit" name="submit" id="submit" class="button button-primary" value="' . esc_html__( 'Save Changes', 'pwf-woo-filter' ) . '">';
			echo '</div>';
			echo '</div>';
			echo '</div>';
			echo '</div></div>';
		}

		/**
		 * Print Add new page Rule Button
		 */
		public static function add_page_rule_link() {
			echo '<a href="#" class="add-new-page-rule page-title-action">+ ' . esc_html__( 'Add New SEO Rules To The Page', 'pwf-woo-filter' ) . '</a>';
		}

		public static function generate_site_map_btn() {
			echo '<button class="generate-xml-sitemap page-title-action" disabled>+ ' . esc_html__( 'Generate Site map', 'pwf-woo-filter' ) . '</button>';
		}

		/**
		 * Display panel Header
		 */
		public static function panel_header( $title, $css, $from_where = '' ) {
			echo '
				<div class="postbox-header ' . esc_attr( $css ) . '">
						<h2 class="hndle">' . esc_attr( $title ) . '</h2>
						<div class="handle-actions hide-if-no-js">';
			if ( 'single_rule' === $from_where ) {
				echo '<button type="button" class="btn-preview-rule" title="' . esc_html__( 'Preview links', 'pwf-woo-filter' ) . '" disabled>
					<span class="preview-indicator"></span>
				</button>';
			}
						echo ' <button type="button" class="btn-delete-rule" title="' . esc_html__( 'Delete', 'pwf-woo-filter' ) . '">
								<span class="delete-indicator"></span>
							</button>
							<button type="button" class="handlediv">
								<span class="toggle-indicator"></span>
							</button>
						</div>
				</div>
			';
		}

		/**
		 * Set HTML for dropdown option
		 * see pages_dropdown_menu
		 *
		 * @since 1.7.7
		 */
		protected static function get_dropdown_option( $id, $text, $checked_value ) {
			echo '<option value ="' . esc_attr( $id ) . '"';
			if ( '' !== $id && $id === $checked_value ) {
				echo ' selected';
			}
			echo '>' . esc_attr( $text ) . '</option>';
		}

		/**
		 * Render Pages Dropdown Menu
		 * @param string selected value
		 * @param array Pages
		 */
		public static function pages_dropdown_menu( $selected_value, $pages ) {
			echo '
				<div class="control-group select-page-for-group-rules">
					<div class="control-label">
						<span class="label-text">' . esc_html__( 'Page', 'pwf-woo-filter' ) . '</span>
						<span class="description tooltip"> <strong>?</strong>
							<span class="tooltiptext tooltip-right">'
							. esc_html__( 'Select the page that you want to add new rewrite rules at the end of its URL', 'pwf-woo-filter' )
							. '</span>
						</span>
					</div>
					<div class="control-content">
						<select name="page-rule" class="form-control full-width dropdown pwf-select2">';
			foreach ( $pages as $page ) {
				if ( ! isset( $page['children'] ) ) {
					self::get_dropdown_option( $page['id'], $page['text'], $selected_value );
				} else {
					echo '<optgroup label="' . esc_attr( $page['text'] ) . '">';
					$options = $page['children'];
					foreach ( $options as $option ) {
						self::get_dropdown_option( $option['id'], $option['text'], $selected_value );
					}
					echo '</optgroup>';
				}
			}

			echo '</select>';
			echo '</div>';
			echo '</div>';
		}

		/**
		 * Render Language Dropdown Menu
		 * @param array Page arguments
		 */
		public static function language_template( $options, $args ) {
			$css_hidden = ' pwf-hidden';
			if ( count( $options ) > 1 ) {
				$css_hidden = '';
			}
			echo '
				<div class="control-group select-lang-for-group-rules' . esc_attr( $css_hidden ) . '">
					<div class="control-label">
						<span class="label-text">' . esc_html__( 'Language', 'pwf-woo-filter' ) . '</span>
					</div>
					<div class="control-content">
						<select name="lang" class="form-control full-width dropdown">';
			foreach ( $options as $option ) {
				$selected_value = $args['lang'] ?? '';
				self::get_dropdown_option( $option['id'], $option['text'], $selected_value );
			}

			echo '</select>';
			echo '</div>';
			echo '</div>';
		}

		/**
		 * Display single rule content
		 */
		public static function rule_content( $args, $fields ) {
			echo '<div class="postbox single-rule closed">';
			self::panel_header( $args['rewrite_rule'], 'rule-panel-header', 'single_rule' );
			echo '<div class="inside element-content">';

			foreach ( $fields as $field ) {
				$field['value'] = $args[ $field['name'] ];
				self::render_field( $field );
			}

			echo '</div>';
			echo '</div>';
		}

		/**
		 * Render field Type
		 */
		public static function render_field( $field ) {
			echo '
				<div class="control-group control-' . esc_attr( $field['css_class'] ) . '">
					<div class="control-label">
						<span class="label-text">' . esc_attr( $field['title'] ) . '</span>';
			self::description( $field['desc'] );
			echo ' </div>
					<div class="control-content">
						<div class="input-field">';
			if ( 'text' === $field['type'] ) {
				self::render_text_input( $field );
			} else {
				self::render_text_area( $field );
			}
			self::render_icon_button( $field );
			echo '     </div>
					</div>
				</div>';
		}

		public static function description( $desc ) {
			if ( empty( $desc ) ) {
				return;
			}
			echo '<span class="description tooltip"> <strong>?</strong>';
			echo '<span class="tooltiptext tooltip-right">' . esc_attr( $desc ) . '</span>';
			echo '</span>';
		}

		public static function render_text_input( $field ) {
			echo '<input type="text" name="' . esc_attr( $field['name'] ) . '" class="' . esc_attr( $field['css_class'] ) . ' form-control full-width text" value="' . esc_attr( $field['value'] ) . '" >';
		}

		public static function render_text_area( $field ) {
			echo '<textarea name="' . esc_attr( $field['name'] ) . '" class="' . esc_attr( $field['css_class'] ) . ' form-control full-width text large-text" rows="2">' . esc_attr( $field['value'] ) . '</textarea>';
		}

		public static function render_icon_button( $field ) {
			if ( isset( $field['button'] ) && ! empty( $field['button'] ) ) {
				$button = $field['button'];
				echo '<div class="btn-exta-links dropdown"><button class="' . esc_attr( $button['css_class'] ) . ' button dropbtn">';
				echo '<span class="dashicons dashicons-ellipsis"></span></button>';
				echo '<div class="dropdown-content">';
				echo '<a href="#" class="btn-clear">' . esc_html__( 'Clear', 'pwf-woo-filter' ) . '</a>';
				if ( 'rewrite_rule' !== $field['name'] ) {
					echo '<a href="#" class="btn-generate">' . esc_html__( 'Generate', 'pwf-woo-filter' ) . '</a>';
				}
				echo '<a href="#" class="btn-available-tags">' . esc_html__( 'Available variables', 'pwf-woo-filter' ) . '</a>';
				echo '</div>';
				echo '</div>';
			}
		}

		public static function add_new_seo_rule_button() {
			echo '<div class="add-new wrap-add-new-rule"><a href="#" class="add-new-rule button button-large">+ ' . esc_html__( 'Add New SEO Rule', 'pwf-woo-filter' ) . '</a></div>';
		}

		protected static function is_plugin_activated() {
			return Pwf_Admin_Main::is_purchase_code();
		}

	}
}
