<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Meta_Fields' ) ) {

	class Pwf_Meta_Fields {

		function __construct() {
		}

		public function get_panel_meta_fields() {
			return $this->meta_fields();
		}

		private function meta_fields() {
			$get_data_options = new Pwf_Meta_Data();

			$fields = array(
				array(
					'type'       => 'text',
					'param_name' => 'title',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'button', 'date', 'search', 'rangeslider', 'rating' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Title', 'pwf-woo-filter' ),
					'default'    => 'Title',
					'required'   => 'true',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'button_action',
					'panel'      => array( 'button' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Action', 'pwf-woo-filter' ),
					'default'    => 'category',
					'options'    => $get_data_options->action_button(),
				),
				array(
					'type'        => 'text',
					'param_name'  => 'css_class',
					'panel'       => array( 'button', 'column' ),
					'group'       => 'general',
					'title'       => esc_html__( 'CSS class', 'pwf-woo-filter' ),
					'placeholder' => 'class-name',
				),
				array(
					'type'       => 'radio',
					'display'    => 'list',
					'param_name' => 'price_url_format',
					'panel'      => array( 'priceslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'URL format', 'pwf-woo-filter' ),
					'default'    => 'dash',
					'required'   => 'true',
					'options'    => $get_data_options->price_url_format(),
				),
				array(
					'type'       => 'radio',
					'display'    => 'list',
					'param_name' => 'range_slider_url_format',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'URL format', 'pwf-woo-filter' ),
					'default'    => 'dash',
					'required'   => 'true',
					'options'    => $get_data_options->price_url_format(),
				),
				array(
					'type'        => 'text',
					'param_name'  => 'url_key',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'date', 'search', 'rangeslider', 'rating' ),
					'group'       => 'general',
					'title'       => esc_html__( 'URL key', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The "URL key" is the URL-friendly version of the title. It is usually all lowercase and contains only letters, numbers, and hyphens', 'pwf-woo-filter' ),
					'placeholder' => 'product-category',
					'required'    => 'true',
				),
				array(
					'type'        => 'text',
					'param_name'  => 'url_key_min_price',
					'panel'       => array( 'priceslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'URL key for minimum price', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The “URL key for minimum price” is the URL-friendly version of “minimum price”. It is usually all lowercase and contains only letters, numbers, and hyphens', 'pwf-woo-filter' ),
					'default'     => 'min-price',
					'required'    => 'true',
				),
				array(
					'type'        => 'text',
					'param_name'  => 'url_key_max_price',
					'panel'       => array( 'priceslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'URL key for max price', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The “URL key for maximum price” is the URL-friendly version of “maximum price”. It is usually all lowercase and contains only letters, numbers, and hyphens.', 'pwf-woo-filter' ),
					'default'     => 'max-price',
					'required'    => 'true',
				),
				array(
					'type'       => 'text',
					'param_name' => 'url_key_date_after',
					'panel'      => array( 'date' ),
					'group'      => 'general',
					'title'      => esc_html__( 'URL key for date after', 'pwf-woo-filter' ),
					'default'    => 'date-after',
					'required'   => 'true',
				),
				array(
					'type'       => 'text',
					'param_name' => 'url_key_date_before',
					'panel'      => array( 'date' ),
					'group'      => 'general',
					'title'      => esc_html__( 'URL key for date before', 'pwf-woo-filter' ),
					'default'    => 'date-before',
					'required'   => 'true',
				),
				array(
					'type'        => 'text',
					'param_name'  => 'url_key_range_slider_min',
					'panel'       => array( 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'URL key for minimum value', 'pwf-woo-filter' ),
					'placeholder' => 'min',
					'required'    => 'true',
				),
				array(
					'type'        => 'text',
					'param_name'  => 'url_key_range_slider_max',
					'panel'       => array( 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'URL key for maximum value', 'pwf-woo-filter' ),
					'placeholder' => 'max',
					'required'    => 'true',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'multi_select',
					'panel'      => array( 'boxlist', 'colorlist', 'textlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Multi Select', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'        => 'radio',
					'param_name'  => 'query_type',
					'panel'       => array( 'checkboxlist', 'colorlist', 'boxlist', 'textlist' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Query type', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Type of query that allows you to apply multiple filters. “And” satisfy both conditions. “Or” satisfy at least one of the conditions', 'pwf-woo-filter' ),
					'default'     => 'or',
					'required'    => 'true',
					'options'     => $get_data_options->query_type(),
				),
				array(
					'type'        => 'sourceofoptions',
					'param_name'  => 'source_of_options',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Source of options', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Select source of options, that will be using to filter products', 'pwf-woo-filter' ),
					'default'     => 'taxonomy',
					'options'     => '',
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'item_source_category',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Category of options', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Choose one of the categories', 'pwf-woo-filter' ),
					'default'     => 'all',
					'required'    => 'true',
					'options'     => $get_data_options->proudct_categories(),
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'item_source_attribute',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Attribute', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Choose one of the attributes created in “Products > Attributes”', 'pwf-woo-filter' ),
					'required'    => 'true',
					'options'     => $get_data_options->proudct_attributes(),
				),
				array(
					'type'        => 'ajaxdropdown',
					'param_name'  => 'item_source_taxonomy',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Taxonomy', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The “Taxonomy” is a grouping mechanism for posts. For example, "category", "product tags" and "product attributes" are also taxonomies', 'pwf-woo-filter' ),
					'required'    => 'true',
					'options'     => '',
				),
				array(
					'type'        => 'ajaxdropdown',
					'param_name'  => 'item_source_taxonomy_sub',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Taxonomy of options', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Choose one of the taxonomies', 'pwf-woo-filter' ),
					'default'     => 'all',
					'required'    => 'true',
				),
				array(
					'type'       => 'ajaxdropdownselect2',
					'param_name' => 'user_roles',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Roles', 'pwf-woo-filter' ),
					'options'    => $get_data_options->user_roles(),
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'item_display',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Display', 'pwf-woo-filter' ),
					'default'    => 'all',
					'options'    => $get_data_options->item_display(),
				),
				array(
					'type'       => 'ajaxcolor',
					'param_name' => 'colors',
					'panel'      => array( 'colorlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Color', 'pwf-woo-filter' ),
				),
				array(
					'type'       => 'ajaxmulticheckboxlist',
					'param_name' => 'include',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Include', 'pwf-woo-filter' ),
				),
				array(
					'type'       => 'ajaxmulticheckboxlist',
					'param_name' => 'exclude',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'rangeslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Exclude', 'pwf-woo-filter' ),
				),
				array(
					'type'        => 'boxlistlabel',
					'param_name'  => 'boxlistlabel',
					'panel'       => array( 'boxlist' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Labels', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Rename fields to display in frontend', 'pwf-woo-filter' ),
				),
				array(
					'type'       => 'multicheckbox',
					'param_name' => 'item_source_orderby',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Order By', 'pwf-woo-filter' ),
					'default'    => array( 'menu_order', 'popularity', 'rating', 'date', 'price', 'price-desc' ),
					'required'   => 'true',
					'options'    => $get_data_options->products_orderby(),
				),
				array(
					'type'       => 'text',
					'param_name' => 'place_holder',
					'panel'      => array( 'search' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Placeholder', 'pwf-woo-filter' ),
					'default'    => esc_html__( 'Search for Products', 'pwf-woo-filter' ),
					'required'   => 'false',
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'search_inside',
					'panel'       => array( 'search' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Search inside', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Limit search for only a product title, and exclude the prdouct content and description.', 'pwf-woo-filter' ),
					'default'     => 'all',
					'options'     => array(
						array(
							'id'   => 'all',
							'text' => esc_html__( 'All', 'pwf-woo-filter' ),
						),
						array(
							'id'   => 'only_title',
							'text' => esc_html__( 'Onlty title', 'pwf-woo-filter' ),
						),
					),
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'range_slider_meta_source',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Source of meta', 'pwf-woo-filter' ),
					'default'    => '_weight',
					'options'    => $get_data_options->range_slider_meta_source(),
				),
				array(
					'type'        => 'text',
					'param_name'  => 'meta_key',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'colorlist', 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Meta key', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The name of the meta to retrieve data from it.', 'pwf-woo-filter' ),
					'default'     => '',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'meta_compare',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'colorlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Meta compare', 'pwf-woo-filter' ),
					'default'    => 'all',
					'options'    => $get_data_options->meta_key_compare_data(),
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'meta_type',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'colorlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Meta type', 'pwf-woo-filter' ),
					'default'    => 'all',
					'options'    => $get_data_options->meta_key_type_data(),
				),
				array(
					'type'       => 'metafield',
					'param_name' => 'metafield',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'colorlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Meta items', 'pwf-woo-filter' ),
				),
				array(
					'type'        => 'switchbutton',
					'param_name'  => 'product_variations',
					'panel'       => array( 'checkboxlist', 'radiolist', 'textlist', 'dropdownlist', 'colorlist', 'boxlist' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Product Variations', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Allow filtering by product variations.', 'pwf-woo-filter' ),
					'default'     => '',
				),
				array(
					'type'       => 'radio',
					'param_name' => 'order_by',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Order by', 'pwf-woo-filter' ),
					'default'    => 'name',
					'options'    => $get_data_options->order_by(),
				),
				array(
					'type'        => 'text',
					'param_name'  => 'slider_range_unit',
					'panel'       => array( 'rangeslider' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Unit', 'pwf-woo-filter' ),
					'description' => esc_html__( 'EX: cm, kg', 'pwf-woo-filter' ),
				),
				array(
					'type'        => 'switchbutton',
					'param_name'  => 'interaction',
					'panel'       => array( 'rangeslider', 'priceslider', 'date' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Enable interaction', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Allow this item to interact with other filter items', 'pwf-woo-filter' ),
					'default'     => '',
				),
				array(
					'type'        => 'switchbutton',
					'param_name'  => 'up_text',
					'panel'       => array( 'rating' ),
					'group'       => 'general',
					'title'       => esc_html__( 'Up text', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Add the "up" text for each rate.', 'pwf-woo-filter' ),
					'default'     => '',
				),
				array(
					'type'       => 'displayrules',
					'param_name' => 'hidden_rules',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'boxlist', 'textlist', 'colorlist', 'search', 'rangeslider', 'rating' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Display rules', 'pwf-woo-filter' ),
					'options'    => array(
						'param' => $get_data_options->rules_parameter(),
						'equal' => $get_data_options->rule_equal(),
					),
				),
				array(
					'type'       => 'number',
					'param_name' => 'width',
					'panel'      => array( 'column' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Width', 'pwf-woo-filter' ),
					'min'        => 1,
					'max'        => 100,
					'required'   => 'true',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'width_unit',
					'panel'      => array( 'column' ),
					'group'      => 'general',
					'title'      => esc_html__( 'Width unit', 'pwf-woo-filter' ),
					'default'    => '%',
					'options'    => array(
						array(
							'id'   => 'px',
							'text' => 'px',
						),
						array(
							'id'   => '%',
							'text' => '%',
						),
					),
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_title',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'date', 'search', 'rangeslider', 'rating' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display title', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_toggle_content',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'date', 'search', 'rangeslider', 'rating' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display toggle content', 'pwf-woo-filter' ),
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'default_toggle_state',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'date', 'search', 'rangeslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Default toggle state', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Default state (show)', 'pwf-woo-filter' ),
					'default'     => 'show',
					'options'     => $get_data_options->default_toggle_state(),
				),
				array(
					'type'        => 'text',
					'param_name'  => 'css_class',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'priceslider', 'date', 'search', 'rangeslider', 'rating' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'CSS class', 'pwf-woo-filter' ),
					'placeholder' => 'class-name',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'dropdown_style',
					'panel'      => array( 'dropdownlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Drop Down Style', 'pwf-woo-filter' ),
					'default'    => 'default',
					'options'    => $get_data_options->dropdown_style(),
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'inline_style',
					'panel'      => array( 'textlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Inline style', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_hierarchical',
					'panel'      => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'textlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display hierarchical', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'multi_select',
					'panel'      => array( 'dropdownlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Multi Select', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'        => 'radio',
					'param_name'  => 'query_type',
					'panel'       => array( 'dropdownlist' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Query type', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Type of query that allows you to apply multiple filters. “And” satisfy both conditions. “Or” satisfy at least one of the conditions', 'pwf-woo-filter' ),
					'default'     => 'or',
					'required'    => 'true',
					'options'     => $get_data_options->query_type(),
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_hierarchical_collapsed',
					'panel'      => array( 'checkboxlist', 'radiolist', 'textlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display hierarchy collapsed', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'box_style',
					'panel'      => array( 'colorlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Style', 'pwf-woo-filter' ),
					'default'    => 'rounded',
					'options'    => array(
						array(
							'id'   => 'rounded',
							'text' => esc_html__( 'Rounded', 'pwf-woo-filter' ),
						),
						array(
							'id'   => 'rectangle',
							'text' => esc_html__( 'Rectangle', 'pwf-woo-filter' ),
						),
					),
				),
				array(
					'type'        => 'dropdown',
					'param_name'  => 'action_for_empty_options',
					'panel'       => array( 'checkboxlist', 'radiolist', 'dropdownlist', 'colorlist', 'boxlist', 'textlist', 'rating' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Action for empty options', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Actions with options when no available products', 'pwf-woo-filter' ),
					'default'     => 'hide',
					'options'     => $get_data_options->action_for_empty_options(),
				),
				array(
					'type'        => 'switchbutton',
					'param_name'  => 'display_product_counts',
					'panel'       => array( 'checkboxlist', 'radiolist', 'textlist', 'dropdownlist', 'colorlist', 'boxlist', 'rating' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Display product counts', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Show/hide product counts in options', 'pwf-woo-filter' ),
					'default'     => 'on',
				),
				array(
					'type'       => 'dropdown',
					'param_name' => 'more_options_by',
					'panel'      => array( 'checkboxlist', 'radiolist', 'textlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'See more options by', 'pwf-woo-filter' ),
					'default'    => 'hide',
					'options'    => $get_data_options->more_options_by(),
				),
				array(
					'type'       => 'number',
					'param_name' => 'height_of_visible_content',
					'panel'      => array( 'checkboxlist', 'radiolist', 'textlist' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Height of visible content', 'pwf-woo-filter' ),
					'min'        => 1,
				),
				array(
					'type'        => 'number',
					'param_name'  => 'size',
					'panel'       => array( 'boxlist', 'colorlist' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'size', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Height and width of item', 'pwf-woo-filter' ),
					'default'     => 45,
					'min'         => 1,
				),
				array(
					'type'       => 'number',
					'param_name' => 'price_step',
					'panel'      => array( 'priceslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Step', 'pwf-woo-filter' ),
					'default'    => 1,
					'min'        => 1,
				),
				array(
					'type'        => 'number',
					'param_name'  => 'price_start',
					'panel'       => array( 'priceslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Start', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Range slider start handle.', 'pwf-woo-filter' ),
					'min'         => 1,
				),
				array(
					'type'        => 'number',
					'param_name'  => 'price_end',
					'panel'       => array( 'priceslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'End', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Range slider end handle.', 'pwf-woo-filter' ),
					'min'         => 1,
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_max_min_inputs',
					'panel'      => array( 'priceslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display max and min inputs', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_price_label',
					'panel'      => array( 'priceslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display price label', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_tooltip',
					'panel'      => array( 'priceslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display Tooltip', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'       => 'number',
					'param_name' => 'step',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Step', 'pwf-woo-filter' ),
					'default'    => 1,
					'min'        => 1,
				),
				array(
					'type'        => 'number',
					'param_name'  => 'start',
					'panel'       => array( 'rangeslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Start', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Range slider start handle.', 'pwf-woo-filter' ),
					'min'         => 1,
				),
				array(
					'type'        => 'number',
					'param_name'  => 'end',
					'panel'       => array( 'rangeslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'End', 'pwf-woo-filter' ),
					'description' => esc_html__( 'Range slider end handle.', 'pwf-woo-filter' ),
					'min'         => 1,
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_max_min_inputs',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display max and min inputs', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_label',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display label', 'pwf-woo-filter' ),
					'default'    => 'on',
				),
				array(
					'type'       => 'switchbutton',
					'param_name' => 'display_tooltip',
					'panel'      => array( 'rangeslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Display Tooltip', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'       => 'depends_on',
					'param_name' => 'depends_on',
					'panel'      => array( 'checkboxlist', 'radiolist', 'textlist', 'dropdownlist', 'colorlist', 'boxlist', 'rating', 'priceslider', 'date', 'search', 'rangeslider' ),
					'group'      => 'visual',
					'title'      => esc_html__( 'Depends on', 'pwf-woo-filter' ),
					'default'    => '',
				),
				array(
					'type'        => 'radio',
					'param_name'  => 'depends_on_operator',
					'panel'       => array( 'checkboxlist', 'radiolist', 'textlist', 'dropdownlist', 'colorlist', 'boxlist', 'rating', 'priceslider', 'date', 'search', 'rangeslider' ),
					'group'       => 'visual',
					'title'       => esc_html__( 'Depends on operator', 'pwf-woo-filter' ),
					'description' => esc_html__( 'The relation between selected options in the option “depends on”. “And” satisfy both conditions. “Or” satisfy at least one of the conditions', 'pwf-woo-filter' ),
					'default'     => 'and',
					'required'    => 'false',
					'options'     => $get_data_options->query_type(),
				),
			);

			return $fields;
		}
	}
}
