<?php

defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'Pwf_Admin_Main' ) ) {

	/**
	 * Enahancement admin
	 * @since 1.5.5
	 */
	class Pwf_Admin_Main {

		/**
		 * @since 1.5.5, 1.6.6
		 */
		public function __construct() {
			add_action( 'admin_init', array( $this, 'admin_init' ), 10 );
			add_action( 'admin_enqueue_scripts', array( $this, 'remove_auto_save_script' ) );
			add_action( 'manage_pwf_woofilter_posts_custom_column', array( $this, 'fill_filter_post_type_columns' ), 10, 2 );
			add_filter( 'manage_pwf_woofilter_posts_columns', array( $this, 'render_filter_post_columns' ) );
			add_action( 'admin_init', array( $this, 'check_current_site' ), 10 );

			// Edit filter post
			add_action( 'admin_enqueue_scripts', array( $this, 'filter_post_enqueue_scripts_styles' ), 10 );
			add_action( 'wp_ajax_get_hierarchy_taxonomies_using_ajax', array( $this, 'get_hierarchy_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_get_group_taxonomies_using_ajax', array( $this, 'get_group_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_get_taxonomies_using_ajax', array( $this, 'get_taxonomies_using_ajax' ) );
			add_action( 'wp_ajax_save_filter_post', array( $this, 'save_filter_post' ) );
			add_action( 'wp_ajax_save_seo_settings', array( $this, 'save_seo_settings' ) );
			add_action( 'wp_ajax_seo_get_page_data', array( $this, 'seo_get_page_data' ) );
			add_action( 'wp_ajax_settings_page', array( $this, 'ajax_settings_page' ) );

			add_action( 'admin_menu', array( $this, 'create_analytic_page' ), 100 );
			add_action( 'wp_ajax_get_ajax_analytic_data_result', array( $this, 'get_ajax_analytic_data_result' ), 10 );

			add_action( 'admin_menu', array( $this, 'create_seo_settings_page' ), 50 );

			// filter to check update
			add_action( 'admin_init', array( $this, 'is_plugin_require_update' ), 10 );
			add_action( 'after_plugin_row_pwfwoofilter/pwfwoofilter.php', array( $this, 'display_update_message' ), 10, 3 );
			add_filter( 'wp_get_update_data', array( $this, 'update_plugins_unmber' ), 10, 2 );
		}

		public function filter_post_enqueue_scripts_styles() {
			global $pagenow, $post;
			if ( ! empty( $pagenow ) && 'post-new.php' === $pagenow || 'post.php' === $pagenow ) {
				if ( 'pwf_woofilter' === $post->post_type ) {
					new Pwf_Meta();
				}
			}
		}

		public function get_hierarchy_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_hierarchy_taxonomies_using_ajax();
		}

		public function get_group_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_group_taxonomies_using_ajax();
		}

		public function get_taxonomies_using_ajax() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->get_taxonomies_using_ajax();
		}

		public function save_filter_post() {
			$pwf_meta = new Pwf_Meta();
			$pwf_meta->save_filter_post();
		}

		public function save_seo_settings() {
			Pwf_Seo_Settings_Page::save_seo_settings();
		}

		public function seo_get_page_data() {
			Pwf_Seo_Settings_Page::get_page_data();
		}

		/**
		 * Ajax for settings page
		 *
		 * @since 1.8.0
		 */
		public function ajax_settings_page() {
			Pwf_Admin_Settings_Page::ajax_settings_page();
		}

		public function create_analytic_page() {
			$submenu = add_submenu_page(
				'edit.php?post_type=pwf_woofilter',
				'Anyalytic Filters',
				'Anyalytics',
				'manage_options',
				'pwf-anyalytics',
				array( $this, 'render_analytic_page' ),
				20
			);

			add_action( 'admin_print_styles-' . $submenu, array( $this, 'analytic_page_enqueue_styles' ) );
			add_action( 'admin_print_scripts-' . $submenu, array( $this, 'analytic_page_enqueue_scripts' ) );
		}

		public function render_analytic_page() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->render_analytic_page();
		}

		public function analytic_page_enqueue_styles() {
			Pwf_Analytic_Page::admin_settings_enqueue_styles();
		}

		public function analytic_page_enqueue_scripts() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->admin_settings_enqueue_scripts();
		}

		/**
		 * Create seo settings page
		 *
		 * @since 1.7.7
		 */
		public function create_seo_settings_page() {
			$seo = add_submenu_page(
				'edit.php?post_type=pwf_woofilter',
				esc_html__( 'SEO Rules', 'pwf-woo-filter' ),
				esc_html__( 'SEO Rules', 'pwf-woo-filter' ),
				'manage_options',
				'pwf-seo',
				array( $this, 'render_seo_settings_page' ),
				20
			);

			add_action( 'admin_print_styles-' . $seo, array( $this, 'seo_settings_page_enqueue_styles' ) );
		}

		/**
		 * @since 1.7.7
		 */
		public function seo_settings_page_enqueue_styles() {
			Pwf_Seo_Settings_Page::enqueue_styles();
		}

		/**
		 * Render SEO settings Page
		 *
		 * @since 1.7.7
		 */
		public function render_seo_settings_page() {
			new Pwf_seo_settings_Page();
		}

		public function get_ajax_analytic_data_result() {
			$analytic = new Pwf_Analytic_Page();
			$analytic->get_ajax_analytic_data_result();
		}

		public function remove_auto_save_script() {
			switch ( get_post_type() ) {
				case 'pwf_woofilter':
					wp_dequeue_script( 'autosave' );
					break;
			}
		}

		public function fill_filter_post_type_columns( $column, $post_id ) {
			if ( 'pwfshortcode' === $column ) {
				echo '[pwf_filter id="' . absint( $post_id ) . '"]';
			}
			if ( 'pwfquerytype' === $column ) {
				$meta       = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
				$settings   = $meta['setting'];
				$query_type = $settings['filter_query_type'] ?? '';
				if ( ! empty( $query_type ) ) {
					if ( 'main_query' === $query_type ) {
						$text = esc_html__( 'Main Query', 'pwf-woo-filter' );
					} else {
						$text = esc_html__( 'Custom Query', 'pwf-woo-filter' );
					}
					echo '<strong>' . esc_attr( $text ) . '</strong>';
				}
			}
			if ( 'pwfpages' === $column ) {
				$meta       = get_post_meta( absint( $post_id ), '_pwf_woo_post_filter', true );
				$settings   = $meta['setting'];
				$query_type = $settings['filter_query_type'] ?? '';
				if ( ! empty( $query_type ) ) {
					if ( 'main_query' === $query_type ) {
						$pages = self::get_filter_pages( $post_id );
						echo wp_kses_post( $pages );
					} else {
						$pages = self::get_filter_pages( $post_id );
						echo wp_kses_post( $pages );
					}
				}
			}
		}

		/**
		 * Get filter pages and display it in columns
		 * @param int $filter_id
		 *
		 * @since 1.6.6
		 *
		 * @return string
		 */
		protected static function get_filter_pages( $filter_id ) {
			$filter_pages = array();
			$pages        = get_option( 'pwf_woo_query_filters', '' );

			if ( ! empty( $pages ) ) {
				$results = array();

				foreach ( $pages as $page_type => $page_filter_id ) {
					if ( absint( $page_filter_id ) === $filter_id ) {
						array_push( $results, $page_type );
					}
				}

				if ( ! empty( $results ) ) {
					foreach ( $results as $page_type ) {
						if ( strpos( $page_type, '__archive' ) !== false ) {
							$type = 'archive';
						} elseif ( strpos( $page_type, 'page__' ) !== false ) {
							$type = 'page';
						} else {
							$type = 'taxonomy';
						}

						$split = explode( '__', $page_type );
						if ( 'archive' === $type ) {
							$label = '<strong>All ' . $split[0] . ' ' . $split[1] . '</strong>';
							array_push( $filter_pages, $label );
						} elseif ( 'taxonomy' === $type ) {
							if ( 'all' === $split[2] ) {
								$taxonomy = get_taxonomy( esc_attr( $split[1] ) );
								if ( ! is_wp_error( $taxonomy ) ) {
									$str = '<strong>All ' . $split[0] . ' ' . $taxonomy->label . '</strong>';
									array_push( $filter_pages, $str );
								}
							} else {
								$term = get_term( absint( $split[2] ), esc_attr( $split[1] ) );
								if ( ! is_wp_error( $term ) ) {
									array_push( $filter_pages, $term->name );
								}
							}
						} elseif ( 'page' === $type ) {
							$page = get_post( absint( $split[1] ) );
							if ( $page ) {
								array_push( $filter_pages, $page->post_title );
							}
						}
					}
				}
			}

			if ( ! empty( $filter_pages ) ) {
				$filter_pages = implode( ', ', $filter_pages );
			} else {
				$filter_pages = '';
			}

			return $filter_pages;
		}

		public function render_filter_post_columns( $columns ) {
			$date = $columns['date'];
			unset( $columns['date'] );
			$columns['pwfshortcode'] = 'Shortcode';
			$columns['pwfquerytype'] = 'Query Type';
			$columns['pwfpages']     = 'Pages';
			$columns['date']         = $date;

			return $columns;
		}

		public function admin_init() {
			self::plugin_version();
		}

		/**
		 * @since 1.2.7, 1.5.5
		 */
		public static function plugin_version() {
			$version = get_option( 'pwf_woocommerce_version' );
			if ( false !== $version && version_compare( $version, PWF_WOO_FILTER_VER, '<' ) ) {
				self::do_update();
				update_option( 'pwf_woocommerce_version', PWF_WOO_FILTER_VER );
				if ( ! Pwf_Main::is_plugin_activated() ) {
					delete_transient( 'dismissed_plugin_pwf_woo_filter' );
				}
			} elseif ( false === $version ) {
				update_option( 'pwf_woocommerce_version', PWF_WOO_FILTER_VER );
			}
		}

		/**
		 * since 1.5.7, 1.6.6
		 */
		protected static function do_update() {
			$version = get_option( 'pwf_woocommerce_version' );

			self::update_purchase_code();

			$filter_id = get_option( 'pwf_shop_filter_id', '' );
			if ( ! empty( $filter_id ) ) {
				$udpate = new pwf_update( array( 'update_filter_post' ) );
			}

			if ( false !== $version && version_compare( $version, '1.5.7', '<' ) ) {
				$udpate = new pwf_update( array( 'add_pretty_urls' ) );
			}

			if ( false !== $version && version_compare( $version, '1.6.9', '<' ) ) {
				$udpate = new pwf_update( array( 'update_filter_to_work_with_any_post_type' ) );
			}

			$db_version = get_option( 'pwf_woocommerce_db_version' );
			if ( false !== $db_version && version_compare( $db_version, PWF_WOO_FILTER_DB_VERSION, '<' ) ) {
				Pwf_Update::update_db_analytics_table();
			}
		}

		/**
		 * Check purchase code every two weeks
		 * @since 1.8.0
		 */
		public function check_current_site() {
			$transient_name = 'pwf_woo_check_purchase_code';
			if ( false === get_transient( $transient_name ) ) {
				$purchase_code = Pwf_Main::get_purchase_code();
				if ( ! empty( $purchase_code ) ) {
					$results = Pwf_Admin_Settings_Page::verify_code( $purchase_code, 'verifycache' );
					if ( 200 === $results['code'] ) {
						set_transient( $transient_name, 'verified', 2 * WEEK_IN_SECONDS );
					} elseif ( isset( $results['message_code'] ) && 5 === absint( $results['message_code'] ) ) {
						self::set_purchase_code( '' );
					}
				}
			}
		}

		/**
		 * @since 1.4.4, 1.5.7
		 */
		private static function update_purchase_code() {
			$purchase_code = get_option( 'envato_purchase_code_28181010' );
			if ( false !== $purchase_code && ! empty( $purchase_code ) ) {
				self::set_purchase_code( $purchase_code );
			}
			delete_option( 'envato_purchase_code_28181010' );
		}

		public static function set_purchase_code( $purchase_code ) {
			if ( Pwf_Main::check_is_network_plugin() ) {
				update_site_option( 'envato_purchase_code_pwf_28181010', esc_attr( $purchase_code ) );
			} else {
				update_option( 'envato_purchase_code_pwf_28181010', esc_attr( $purchase_code ) );
			}
		}

		/**
		 * Add count number to the plugin menus - Left side menu
		 *
		 * @since 1.8.0
		 *
		 * @return int
		 */
		public function update_plugins_unmber( $update_data, $titles ) {
			if ( self::is_require_update() ) {
				$update_data['counts']['plugins'] += 1;
			}
			return $update_data;
		}

		/**
		 * Display update message admin > plugins page
		 *
		 * @since 1.8.0
		 *
		 * @return string
		 */
		public function display_update_message( $plugin_file, $plugin_data, $status ) {
			if ( self::is_require_update() ) {
				$new_version = get_option( 'pwf_woo_is_plugin_require_update' );
				echo '<tr class="plugin-update-tr" id="pwfwoofilter-update" data-slug="pwfwoofilter">';
				echo '<td colspan="4" class="plugin-update colspanchange">';
				echo '<div class="update-message notice inline notice-warning notice-alt">';
				echo '<p>There is a new version <strong>' . esc_attr( $new_version ) . '</strong> of ' . esc_attr( $plugin_data['Name'] );
				echo '. Go to download page on Codecanyon.</p>';
				echo '</div></td></tr>';
			}

			return $plugin_file;
		}

		/**
		 * Check is there a new plugin version
		 *
		 * @since 1.8.0
		 *
		 * @return avoid
		 */
		public function is_plugin_require_update() {
			$transient_name = 'pwf_woo_check_plugin_update';
			$option_name    = 'pwf_woo_is_plugin_require_update';

			if ( false === get_transient( $transient_name ) ) {
				$end_point = 'https://mostafaa.net/pwfupdate/pwfwoocommerceupdate.json';
				$args      = array(
					'timeout' => 10,
					'headers' => array(
						'Content-Type' => 'application/json',
					),
				);

				$response      = wp_remote_get( $end_point, $args );
				$response_code = absint( wp_remote_retrieve_response_code( $response ) );

				if ( 200 === $response_code ) {
					$body    = json_decode( wp_remote_retrieve_body( $response ), true );
					$version = $body['version'];
					if ( version_compare( $version, PWF_WOO_FILTER_VER, '>' ) ) {
						update_option( $option_name, $version, 'yes' );
					}
					set_transient( $transient_name, $version, 15 * DAY_IN_SECONDS );
				} else {
					set_transient( $transient_name, 'true', DAY_IN_SECONDS );
				}
			}
		}

		/**
		 * Check to display update message on the plugins page
		 *
		 * @since 1.8.0
		 *
		 * @return bool
		 */
		public static function is_require_update() {
			$version = get_option( 'pwf_woo_is_plugin_require_update', '' );
			if ( ! empty( $version ) && version_compare( $version, PWF_WOO_FILTER_VER, '>' ) ) {
				return true;
			}

			return false;
		}

		/**
		 * @since 1.8.0
		 */
		public static function is_purchase_code() {
			$purchase_code = Pwf_Main::get_purchase_code();
			if ( ! empty( $purchase_code ) ) {
				return true;
			}

			return false;
		}

		/**
		 * @since 1.8.0
		 */
		public static function is_development_site() {
			$host = Pwf_Main::get_site_url();

			$chunks = explode( '.', $host );

			if ( 1 === count( $chunks ) ) {
				return true;
			}

			$dev_sites = array( 'dev', 'local', 'test', 'wp', 'example', 'invalid', 'localhost' );

			if ( in_array( end( $chunks ), $dev_sites, true ) ) {
				return true;
			}

			if ( preg_match( '/^[0-9\.]+$/', $host ) ) {
				return true;
			}

			return false;
		}

		/**
		 * Used to check is_purchase_code && is_development_site
		 *
		 * @since 1.8.0
		 */
		public static function is_plugin_activated() {
			return ( self::is_development_site() || self::is_purchase_code() );
		}

	}

	new Pwf_Admin_Main();
}
