(function( $ ) {
	"use strict";
	$('.pwf-settings-page').on('click', '.verify-purchase-code', function( event ) {
		event.preventDefault();
		handleAjax('verify');
	});
	$('.pwf-settings-page').on('click', '.delete-purchase-code', function( event ) {
		event.preventDefault();
		handleAjax('delete');
	});

	function handleAjax( action ) {
		let purchaseCode = '';
		if ( 'verify' === action ) {
			purchaseCode = $('[name="envato_purchase_code_28181010"]').val();
		}
		$.ajax({
			type: 'POST',
			dataType: 'json',
			url: ajaxurl,
			data: {
				'action':  'settings_page',
				'nonce':   pwf_woo_settings_page.nonce,
				'data':    action,
				'purchase_code': purchaseCode,
			},
			beforeSend : function() {
				if ( $('.pwf-overlay').length > 0 ) {
					$('.pwf-overlay').removeClass('pwf-unactive').addClass('pwf-active');
				} else {
					$('body').prepend('<div class="pwf-overlay pwf-active"><span class="pwf-loader"></span></div>');
				}
			}
		}).done( function( result ) {	
			$('.purchase-code-message').empty();
			if ( 'error' === result.message_type ) {
				$('.purchase-code-message').append('<span class="message error-message">' +  result.message + '</span>');
			} else {
				$('.purchase-code-message').append('<span class="message success-message">' +  result.message + '</span>');
				if ( 'delete' === action ) {
					$('[name="envato_purchase_code_28181010"]').val('');
				}
			}
		}).fail( function(jqXHR, textStatus, errorThrown) {
			$('.purchase-code-message').empty();
			$('.purchase-code-message').append('<span class="message error-message">' +  errorThrown + '</span>');
		}).always( function() {
			$('.pwf-overlay').removeClass('pwf-active').addClass('pwf-unactive');
		});
	}

}(jQuery));