(function( $ ) {
	"use strict";

	$('.if-js-closed').removeClass('if-js-closed').addClass('closed');

	var separator = '%';

	var controllerPageRule = {
		btnCSSSelector: 'add-new-page-rule',

		create: function() {
			let output = '';

			output += '<div class="single-page-rule-content postbox">';
			output += controllerRule.createHeader( '#', 'page-panel-header', 'page_rule' );
			output += '<div class="inside">';
			output += this.pagesDropdownMenu();
			output += this.LanguagesDropdownMenu();
			output += '<div class="inside-content group-page-rules">';
			output += '</div>';
			output += this.btnAddNewRule();
			output += '</div>';
			output += '</div>';
			this.appendPage(output);
		},
		getDropdownOption: function( id, text ) {
			let output = '<option value ="' + id + '">' + text + '</option>';
			return output;
		},
		pagesDropdownMenu: function() {
			let pages  = pro_woo_filter_seo_settings.pages;
			let output = '';

			output += '<div class="control-group select-page-for-group-rules">';
			output += '<div class="control-label">';
			output += '<span class="label-text">' + translatedText.page + '</span>';
			output += '<span class="description tooltip"> <strong>?</strong>';
			output += '<span class="tooltiptext tooltip-right">' + translatedText.select_page + '</span>';
			output += '</span>';
			output += '</div>';
			output += '<div class="control-content">';
			output += '<select name="page-rule" class="form-control full-width dropdown pwf-select2">';

			const keys = Object.keys(pages);
			for ( const key of keys ) {
				let currentPage = pages[key];
				if ( ! currentPage.hasOwnProperty('children') ) {
					output += this.getDropdownOption( currentPage['id'], currentPage['text'] );
				} else {
					output += '<optgroup label="' + currentPage['text'] + '">';

					let options = currentPage['children'];
					const childernKeys = Object.keys(options);
					for ( const key of childernKeys ) {
						let currentChildernPage = options[key];
						output += this.getDropdownOption( currentChildernPage['id'], currentChildernPage['text'] );
					}
					output += '</optgroup>';
				}
			}
			
			output += '</select>';
			output += '</div>';
			output += '</div>';
			return output;
		},
		LanguagesDropdownMenu: function() {
			let languages_options = pro_woo_filter_seo_settings.language_options;
			let currentLanguage   = pro_woo_filter_seo_settings.current_language;
			let output = '';

			let CssClassHidden = ' pwf-hidden';
			if ( languages_options.length > 1 ) {
				CssClassHidden = '';
			}

			output += '<div class="control-group select-lang-for-group-rules' + CssClassHidden + '">';
			output += '<div class="control-label">';
			output += '<span class="label-text">' + translatedText.language + '</span>';
			output += '</div>';
			output += '<div class="control-content">';
			output += '<select name="lang" class="form-control full-width dropdown">';

			const keys = Object.keys(languages_options);
			for ( const key of keys ) {
				let language = languages_options[key];
				output += '<option value ="' + language['id'] + '"';
				if ( currentLanguage === language['id'] ) {
					output += ' selected';
				}
				output += '>' + language['text'] + '</option>';
			}

			output += '</select>';
			output += '</div>';
			output += '</div>';

			return output;
		},
		getNewPageIndex: function() {
			// not important
		},
		btnAddNewRule: function () {
			let output = '<div class="add-new wrap-add-new-rule"><a href="#" class="add-new-rule button button-large">+ ';
			output += translatedText.add_new_rule + '</a></div>';
			//output 
			return output;
		},
		appendPage: function(htmlContent) {
			$('.seo-page-content').append( htmlContent );
			$('.single-page-rule-content').last().find('.pwf-select2').select2({
				width:'100%',
			});
		},
		disableCreatePageRule: function() {
			// set button to disabled untill finish add new page rule panel
		},
		enableCreatePageRule: function() {
			// Enable Button add new Page rule
		}
	};

	var controllerRule = {
		createHeader: function( title, css, from_where = 'single_rule' ) {
			let output = '<div class="postbox-header ' + css + '">' +
							'<h2 class="hndle">' + title + '</h2>' +
							'<div class="handle-actions hide-if-no-js">';
			if ( 'from_where' === from_where ) {
				output += '<button type="button" class="btn-preview-rule" title="' + translatedText.preview_links + '" disabled>' +
							'<span class="preview-indicator"></span>' +
						  '</button>';
			}
			
			output +=			'<button type="button" class="btn-delete-rule" title="' + translatedText.delete + '">' +
									'</span><span class="delete-indicator"></span>' +
								'</button>' +
								'<span class="hidden">Delete</span>' +
								'<button type="button" class="handlediv">' +
									'<span class="toggle-indicator"></span>' +
								'</button>' +
							'</div>' + 
						'</div>';
			
			return output;
		},
		renderTextInput: function (field ) {
			let cssClass = field['css_class'] + ' form-control full-width text';
			return '<input type="text" name="' + field['name'] + '" class="' + cssClass + '" value="' + field['value'] + '" >';
		},
		renderTextArea: function( field ) {
			let cssClass = field['css_class'] + ' form-control full-width text large-text';
			return '<textarea name="' + field['name'] + '" class="' + cssClass + '" rows="2">' + field['value'] + '</textarea>';
		},
		renderIconButton: function( field ) {
			let button = field['button'];
			let output = '<div class="btn-exta-links dropdown">';

			output += '<button class="' + button['css_class'] + ' button dropbtn">';
			output += '<span class="dashicons dashicons-ellipsis"></span>';
			output += '</button>';
			output += '<div class="dropdown-content">';
			output += '<a href="#" class="btn-clear">' + translatedText.clear + '</a>';
			if ( 'rewrite_rule' !== field['name'] ) {
				output += '<a href="#" class="btn-generate">' + translatedText.generate + '</a>';
			}
			output += '<a href="#" class="btn-available-tags">' + translatedText.variables + '</a>';
			output += '</div>';    				
			output += '</div>';

			return output;
		},
		renderDescription: function ( desc ) {
			if ( '' === desc ) {
				return '';
			}
			let output = '<span class="description tooltip"> <strong>?</strong>';
			output    += '<span class="tooltiptext tooltip-right">' + desc + '</span>';
			output    += '</span>';
			return output;
		},
		renderField: function ( field ) {
			let output = '';
			
			output += '<div class="control-group control-' + field['css_class'] + '">';
			output += '<div class="control-label">';
			output += '<span class="label-text">' + field['title'] + '</span>';
			output += this.renderDescription( field['desc'] );
			output += '</div>';
			output += '<div class="control-content">';
			output += '<div class="input-field">';
			
			if ( 'text' === field['type'] ) {
				output += this.renderTextInput( field );
			} else {
				output += this.renderTextArea( field );
			}
			output += this.renderIconButton( field );
			output += '</div>';				
			output += '</div>';
			output += '</div>';

			return output;
		},
		generateNewRuleFields: function() {
			let output = '';

			output += '<div class="postbox single-rule">';
			output += this.createHeader('#', 'rule-panel-header');
			output += '<div class="inside element-content">';

			let fields = pro_woo_filter_seo_settings.default_fields;
			const keys = Object.keys(fields);
			for ( const key of keys ) {
				let field = fields[key];
				output += this.renderField( field );
			}
			output += '</div>';
			output += '</div>';

			return output;
		},
		btnAddNewRule: function( btnSource ) {
			let selectedPage = $(btnSource).closest('.single-page-rule-content').find('[name="page-rule"]').val();
			if ( '' === selectedPage ) {
				alert( translatedText.select_page );
			} else {
				let output = this.generateNewRuleFields();
				$(btnSource).closest('.inside').find('.inside-content').append( output );
			}
		}
	};

	var controllerEvents = {
		init: function() {
			/**
			 * Init events
			 */
			$('.pwf-layout').on('click', '.add-new-page-rule', function( event ) {
				event.preventDefault();
				controllerPageRule.create();
				controllerEvents.refreshSortPagePanels();
			});
			$('.pwf-layout').on('click', '.add-new-rule', function( event ) {
				event.preventDefault();
				controllerRule.btnAddNewRule( $(this ) );
				controllerEvents.refreshSortrulePanels();
			});

			$('.pwf-layout').on('click', '.handlediv', function( event ) {
				event.preventDefault();
				if ( $(this).closest('.postbox').hasClass('closed') ) {
					$(this).closest('.postbox').removeClass('closed');
				} else {
					$(this).closest('.postbox').addClass('closed')
				}
			});

			$('.pwf-layout').on('click', '.btn-delete-rule', function( event ) {
				event.preventDefault();
				var retVal = confirm( translatedText.delete_rule );
				if( retVal == true ) {
					$(this).closest('.postbox').remove();
				   return true;
				} else {
				   return false;
				}
			});

			$('.pwf-layout').on('click', '.btn-preview-rule', function( event ) {
				event.preventDefault();
				alert( translatedText.no_feature );
			});

			$('.pwf-layout').on('click', '#submit', function( event ) {
				event.preventDefault();
				saveRoles.saveData();
			});
			$('.pwf-layout').on('click', '.save-seo-options', function( event ) {
				event.preventDefault();
				saveRoles.saveData();
			});

			$('.pwf-select2').each( function() {
				$(this).select2({ width:'100%'});
			});

			$('.pwf-layout').on('click', '.dropbtn', function( event ) {
				event.preventDefault();
				$(this).closest('.btn-exta-links').find('.dropdown-content').addClass('show');
			});

			$(window).on('click', '', function( event ) {
				let isMenuTaregt = false;
				let $taregt      = $(event.target);

				if ( $taregt.hasClass('dropbtn') ) {
					isMenuTaregt = true;
				} else if ( $taregt.hasClass('dashicons-ellipsis') ) {
					isMenuTaregt = true;
				}

				if ( ! isMenuTaregt) {
					$('.dropdown-content').removeClass('show');
				}
			});

			$('.pwf-layout').on('click', '.btn-available-tags', function( event ) {
				event.preventDefault();
				infoPanelData.init( $(this) );
			});
			$('.pwf-layout').on('click', '.btn-hide-panel', function( event ) {
				$(this).closest('.info-field').addClass('pwf-hidden');
			});

			$('.pro-woo-filter').on('click', '.tab-navs a', function( event ) {
				event.preventDefault();
				$(this).closest('.info-content').find('.active-tab').removeClass('active-tab');
				$(this).addClass('active-tab');
				let currentTab = $(this).attr('data-tab-id');
				$(this).closest('.info-content').find('.tab-content').hide();
				$(this).closest('.info-content').find('[data-tab-id=' + currentTab +']').addClass('active-tab').show();
			});
			
			this.sortPanels();

			$('.pro-woo-filter').on('click', '.btn-clear', function( event ) {
				event.preventDefault();
				let inputField = $(this).closest('.control-content').find('.input-field').find('.form-control');
				let value      = $(inputField).val();
				if ( '' !== value ) {
					let confirmBox = confirm( translatedText.delete_input );
					if( confirmBox == true ) {
						$(inputField).val('');
						return true;
					}
				}
			});

			$('.pro-woo-filter').on('click', '.add-tag', function( event ) {
				event.preventDefault();
				let inputField = $(this).closest('.control-content').find('.input-field').find('.form-control');
				let currentTxt = $(inputField).val() + $(this).attr('data-value');
				$(inputField).val( currentTxt );
			});

			$('.pro-woo-filter').on('click', '.btn-generate', function( event ) {
				event.preventDefault();
				infoPanelData.init( $(this) );
			});

			$('.pro-woo-filter').on('change', '[name="page-rule"]', function( event ) {
				event.preventDefault();
				getFilterID.init( $(this) );
			});

			/**
			 * Loop through each page to check the filter id doesn't exist
			 */
			$('.single-page-rule-content').each( function() {
				if ( 0 == $(this).attr('data-filter-id') ) {
					let errorMessage = '<div class="pwf-error"><p>' + translatedText.selected_error + '</p></div>';
					$(this).find('.pwf-page-rule-error-message').append( errorMessage );
					$(this).find('.add-new-rule').addClass('isdisabled');
				}
			});

			$('.inside-content h2').each( function() {
				let h2 = $(this).text();
				h2     = h2.replaceAll( '%', '<span class="pwf-title-tag">%</span>' );
				/*let pattern = /%[A-Za-z0-9\-\_]+%/g;
				let result  = h2.match(pattern);
				if ( null != result ) {
					//let new
					result.forEach( function( replaced ) {
						let newReplaced = '<span class="pwf-title-tag">' + replaced + '</span>';
						h2              = h2.replaceAll( replaced, newReplaced );
					});
				}
				*/
				$(this).html( h2 );
			});

			
		},
		sortPanels: function() {
			$('.panel-group').sortable({
				handle: ".page-panel-header",
				placeholder: 'ui-state-highlight',
				forcePlaceholderSize: true,
				opacity: 0.8,
				helper: 'clone',
				start: function (event, ui) {
					var width = $(this).width();
					$(ui.helper).width(width);
				}
			});

			$('.group-page-rules').sortable({
				handle: ".rule-panel-header",
				placeholder: 'ui-state-highlight',
				forcePlaceholderSize: true,
				opacity: 0.8,
				helper: 'clone',
				start: function (event, ui) {
					var width = $(this).width();
					$(ui.helper).width(width);
				}
			});
		},
		refreshSortPagePanels: function() {
			$('.panel-group').sortable("refresh");
		},
		refreshSortrulePanels: function() {
			$('.group-page-rules').each( function() {
				if ( $(this).hasClass('ui-sortable') ) {
					$(this).sortable("refresh");
				} else {
					$(this).sortable({
						handle: ".rule-panel-header",
						placeholder: 'ui-state-highlight',
						forcePlaceholderSize: true,
						opacity: 0.8,
						helper: 'clone',
						start: function (event, ui) {
							var width = $(this).width();
							$(ui.helper).width(width);
						}
					});
				}
			});
		}
	};

	/**
	 * When user change Current page that display SEO Rules Or add new page rule
	 */
	var getFilterID = {
		init:function( selectedPage ) {
			this.currentSelectedPage = $(selectedPage);

			let currentPanel  = this.currentSelectedPage.closest('.single-page-rule-content');
			let selectedValue = this.currentSelectedPage.val();
			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: ajaxurl,
				data: {
					'action':  'seo_get_page_data',
					'nonce':   pro_woo_filter_seo_settings.nonce,
					'page_type':    selectedValue,
				},
				beforeSend : function() {
					if ( $('.pwf-overlay').length > 0 ) {
						$('.pwf-overlay').removeClass('pwf-unactive').addClass('pwf-active');
					} else {
						$('body').prepend('<div class="pwf-overlay pwf-active"><span class="pwf-loader"></span></div>');
					}
				}
			}).done( function( result ) {
				if ( 'true' === result.success ) {
					/**
					 * check is filter id is empty 
					 * display error messge and also alert box
					 * disable add new rule button
					 */
					if ( result.filter_id == '' ) {
						alert( translatedText.selected_error );
						if ( ! (currentPanel).find('.pwf-page-rule-error-message').find('.notice').length > 0 ) {
							let errorMessage = '<div class="notice notice-error is-dismissible"><p>' + translatedText.selected_error + '</p></div>';
							$(currentPanel).find('.pwf-page-rule-error-message').append( errorMessage );
						}
						$(currentPanel).find('.add-new-rule').addClass('isdisabled');
						$(currentPanel).find('.pwf-page-rule-error-message').find('.pwf-error').remove();
					} else {
						$(currentPanel).find('.pwf-page-rule-error-message').find('.pwf-error').remove();
						$(currentPanel).find('.pwf-page-rule-error-message').find('.notice').remove();

						if ( $(currentPanel).find('.add-new-rule').hasClass('isdisabled') ) {
							$(currentPanel).find('.add-new-rule').removeClass('isdisabled')
						}

						$(currentPanel).attr('data-filter-id', result.filter_id );
						$(currentPanel).attr('data-page-type', selectedValue );
						$(currentPanel).attr('data-page-url', result.page_url );

						// append filter_data to 
						let filterIDExsit     = false
						let currentFilterData = result.filter_data;
						let allFilter = pro_woo_filter_seo_settings.filters_data;
						allFilter.forEach( function( filter ) {
							if ( parseInt( currentFilterData['filter_id'] ) == parseInt( filter['filter_id'] ) ) {
								filterIDExsit = true ;
							}
						});

						if ( ! filterIDExsit ) {
							pro_woo_filter_seo_settings.filters_data.push(currentFilterData);
						}
					}
				} else {
					let ErrorMessage = '<div class="notice notice-error is-dismissible"><p>' + result.message + '</p></div>';
					$('.pwf-error-message').append(ErrorMessage);
				}
			}).fail( function(jqXHR, textStatus, errorThrown) {
				$('.pwf-error-message').append('<span class="message error-message">' +  errorThrown + '</span>');
			}).always( function() {
				$('.pwf-overlay').removeClass('pwf-active').addClass('pwf-unactive');
			});
			/*
			* check if this pro_woo_filter_seo_settings.filters_data; has filter_id
			* No get filter data from ajax
			* add data-filter-id = 
			* 
			*/
			//infoPanelData.init( $(this) );
		}
	};
	var infoPanelData = {
		clickedButton: '',
		init: function( clickedButton ) {
			this.clickedButton = $( clickedButton );

			if ( $(clickedButton).closest('.control-group').hasClass('control-rewrite-rule') ) {
				this.urlRewriteRuleTags();
			} else {
				let urlRule = this.clickedButton.closest('.element-content').find('.rewrite-rule').val();
				if ( '' === urlRule ) {
					alert( translatedText.empty_rule_url );
					return;
				}
				if ( this.clickedButton.hasClass('btn-generate') ) {
					this.generateTitle();
				} else if ( this.clickedButton.hasClass('btn-available-tags') ) {
					this.createAvailableSeoMetaKeys();
				}
			}
		},
		panelTemplate: function( css = '' ) {
			let output = '';
			output += '<div class="info-field pwf-hidden">';
			output += '<div class="info-header">';
			output += '<button type="button" class="btn-hide-panel">';
			output += '<span class="hide-indicator"><span class="dashicons dashicons-hidden"></span></span>';
			output += '</button>';
			output += '</div>'
			output += '<div class="info-content ' + css + '"></div>';
			output += '</div>';
			
			return output;
		},
		urlRewriteRuleTags() {
			if ( this.clickedButton.closest('.control-content').find('.info-field').length > 0 ) {
				this.clickedButton.closest('.control-content').find('.info-field').toggleClass('pwf-hidden');
			} else {
				let output = '';

				let finalContent = this.getUrlTag();

				output = '<div class="tab-navs"><ul>';
				output += finalContent['tabNav'];
				output += '</ul></div>';
				output += finalContent['tabcontent'];
				output += '<div class="clear"></div>';
				let panelTemplate = this.panelTemplate( 'contain-tab-content' );
				this.clickedButton.closest('.control-content').append( panelTemplate );
				this.clickedButton.closest('.control-content').find('.info-content').append( output );
				this.clickedButton.closest('.control-content').find('.info-field').removeClass('pwf-hidden');
			}
		},
		getUrlTag: function() {
			let tabNav     = '';
			let tabContent = '';
			let urlKeys    = this.getAllUrlKeys();

			let index  = 1;
			const keys = Object.keys(urlKeys);
			for ( const key of keys ) {
				let urlKey = urlKeys[ key ];
				let innertabContent = '';
				let sameSource      = [ 'taxonomy', 'author', 'on_sale', 'featured', 'rating', 'meta' ];
				if ( sameSource.includes( urlKey['source'] ) ) {
					innertabContent = this.getTaxonomiesURLS( key, urlKey );
				} else if ( 'priceslider' === urlKey['field_type'] || 'rangeslider' === urlKey['field_type'] ) {
					innertabContent = this.getRangeSliderURLS( key, urlKey );
				} else if ( 'search' === urlKey['source'] ) {
					let value  = key + '-for-' + separator + 'seaarch_text' + separator + '/';
					let output = '<button class="add-tag button button-large" data-value="' + value + '">' + value + '</button>';
					innertabContent = output;
				}

				let liCssClass  = ( 1 === index ) ? 'tablinks active-tab' : 'tablinks';
				let tabCssClass = ( 1 === index ) ? 'tab-content active-tab' : 'tab-content';
				
				tabNav += '<li><a href="#" class="' + liCssClass + '" data-tab-id="tab-' + index + '">' + key + '</a></li>';
				tabContent += '<div id="tab-' + index + '" class="' + tabCssClass + '" data-tab-id="tab-' + index + '"><div class="inner-tab">' + innertabContent + '</div></div>';

				index++;
			}
			
			let result = {
				'tabNav': tabNav,
				'tabcontent': tabContent,
			};

			return result;
		},
		getFilterData: function( filterID ) {
			let filterData = '';
			let allFilter = pro_woo_filter_seo_settings.filters_data;
			allFilter.forEach( function( filter ) {
				if ( parseInt( filterID ) == parseInt( filter['filter_id'] ) ) {
					filterData =  filter;
				}
			});

			return filterData;
		},
		getTaxonomiesURLS: function( urlKey, field ) {
			let output = '';
			let values = field['values']
			if ( ! [ 'on_sale', 'featured' ].includes( field['source'] ) ) {
				let value = urlKey + '-' + separator + 'any' + separator + '/';
				output += '<button class="add-tag button button-large" data-value="' + value + '">' + value + '</button>';
			}
			values.forEach( function( valueobj ) {
				let value = urlKey + '-' + separator + valueobj['slug'] + separator;
				output += '<button class="add-tag button button-large" data-value="' + value + '/">' + value + '/</button>';
			});

			return output;
		},
		getRangeSliderURLS: function ( urlKey, field ) {
			let value  = urlKey + '-' + separator + 'min_value-to-max_value' + separator + '/';
			let output = '<button class="add-tag button button-large" data-value="' + value + '">' + value + '</button>';
			return output;
		},
		createAvailableSeoMetaKeys: function() {
			// this field must generate each time.
			if ( this.clickedButton.closest('.control-content').find('.info-field').length > 0 ) {
				this.clickedButton.closest('.control-content').find('.info-field').remove();
			}

			let output  = '';
			let urlRule = this.getURLRewriteRuleKeys();
			if ( urlRule.length === 0 ) {
				//URL rule is empty
				output = translatedText.empty_rule_url;
			} else {
				let getKeys    = this.getOrginalKeysFromUrlRewriteField();
				let usedKeys   = getKeys['usedKeys'];
				let unusedKeys = getKeys['unusedKeys'];
				
				/**
				 * Add site_name and page_title
				 */
				if ( ! this.clickedButton.closest('.control-group').hasClass('control-breadcumbs') ) {
					usedKeys.unshift('page_title');
					usedKeys.unshift('site_name');
				}

				/**
				 * Remove site name
				 */
				if ( this.clickedButton.closest('.control-group').hasClass('control-h1-title') ) {
					usedKeys = usedKeys.slice(1);
				}

				output += '<div class="used-keys">';
				usedKeys.forEach( function ( value ) {
					value   = separator + value + separator;
					output += '<button class="add-tag button button-large" data-value="' + value + '">' + value + '</button>';
				});
				output += '</div>';

				if ( unusedKeys.length > 0 ) {
					output += '<div class="unused-keys">';
					output += '<p>' + translatedText.var_not_exists + '</p>';
					unusedKeys.forEach( function ( value ) {
						value   = separator + value + separator;
						output += '<button class="add-tag button button-large" data-value="' + value + '" disabled>' + value + '</button>';
					});
					output += '</div>';
				}
			}

			let panelTemplate = this.panelTemplate('has-padding');
			this.clickedButton.closest('.control-content').append( panelTemplate );
			this.clickedButton.closest('.control-content').find('.info-content').append( output );
			this.clickedButton.closest('.control-content').find('.info-field').removeClass('pwf-hidden');
		},
		/**
		 * @param {Boolean} onlyKeys return only keys
		 * @returns array
		 */
		getAllUrlKeys: function() {
			let filterID   = this.clickedButton.closest('.single-page-rule-content').attr('data-filter-id');
			let filterData = this.getFilterData(filterID);
			let urlKeys    = filterData['url_keys'];

			return urlKeys;
		},
		getURLRewriteRuleKeys: function() {
			let result  = [];
			let urlRule = this.clickedButton.closest('.element-content').find('.rewrite-rule').val();
			if ( '' !== urlRule ) {
				result = urlRule.split('/').filter(element => element);
			}

			return result;
		},
		/**
		 * Used to generate title & Meta Title & meta description
		 */
		generateTitle: function() {
			let output   = '';
			let getKeys  = this.getOrginalKeysFromUrlRewriteField();
			let usedKeys = getKeys['usedKeys'];
			if ( usedKeys.length > 0 ) {
				if ( ! this.clickedButton.closest('.control-group').hasClass('control-breadcumbs') ) {
					output += 'Best ' + separator + 'page_title' + separator + ' Replace_Me';
				}
				usedKeys.forEach( function( urlKey ) {
					output += ' '+ separator + urlKey + separator + ' Replace_Me';
				});
				if ( this.clickedButton.closest('.control-group').hasClass('control-meta-title') ) {
					output += ' | ' + separator + 'site_name' + separator;
				}
				this.clickedButton.closest('.control-content').find('.form-control').val( output );
			} else {
				alert( translatedText.empty_rule_url );
			}
		},
		getOrginalKeysFromUrlRewriteField: function() {
			let usedKeys                  = [];
			let unusedKeys                = [];
			let urlRewriteRuleKeyIncluded = []
			let urlRewriteRule            = this.getURLRewriteRuleKeys();
			let allUrlKeys                = this.getAllUrlKeys();

			urlRewriteRule.forEach( function( urlKey ) {
				let position = urlKey.search( '-' + separator );
				if ( -1 !== position ) {
					let currentKey = urlKey.slice( 0, position );
					urlRewriteRuleKeyIncluded.push( currentKey );
				}
			});
			
			const keys = Object.keys(allUrlKeys);
			for ( const key of keys ) {
				let itemData      = allUrlKeys[key];

				/**
				 * Important code because  the URL rewrite rule
				 * For a search using url_key plus for EX, search-for-
				 */
				let urlKeyCompare = key;
				if ( 'search' === itemData['field_type'] ) {
					urlKeyCompare = key + '-for';
				}

				if ( urlRewriteRuleKeyIncluded.includes( urlKeyCompare ) ) {
					if ( 'priceslider' === itemData['field_type'] || 'rangeslider' === itemData['field_type'] ) {
						usedKeys.push( key + '_min_value');
						usedKeys.push( key + '_max_value');
					} else {
						usedKeys.push(key);
					}

				} else {
					if ( 'priceslider' === itemData['field_type'] || 'rangeslider' === itemData['field_type'] ) {
						unusedKeys.push( key + '_min_value' );
						unusedKeys.push( key + '_max_value' );
					} else {
						unusedKeys.push(key);
					}

				}
			}

			return {
				'usedKeys':   usedKeys,
				'unusedKeys': unusedKeys
			};
		}
	};

	var saveRoles = {
		getRulesData: function() {
			let dataToSaved = [];
			$('.single-page-rule-content').each( function() {
				let PageType = $(this).find('[name="page-rule"]').val();
				if ( '' !== PageType ) {
					let rules = [];
					let grouprules = $(this).find('.group-page-rules').find('.single-rule');
					if ( grouprules.length > 0 ) {
						$(grouprules).each( function() {
							let rule = {};
							rule['rewrite_rule']      = $(this).find('[name="rewrite_rule"]').val();
							rule['h1_title']          = $(this).find('[name="h1_title"]').val();
							rule['meta_title']        = $(this).find('[name="meta_title"]').val();
							rule['meta_description']  = $(this).find('[name="meta_description"]').val();
							rule['breadcumbs']        = $(this).find('[name="breadcumbs"]').val();
							rule['short_description'] = $(this).find('[name="short_description"]').val();
							rules.push(rule);
						});
					}
					
					let savePageRule = {
						'page_type': PageType,
						'lang': $(this).find('[name="lang"]').val(),
						'rules': rules,
					};

					dataToSaved.push( savePageRule );
				}
			});
			return dataToSaved;
		},
		saveData: function() {
			let savedData = this.getRulesData();

			$.ajax({
				type: 'POST',
				dataType: 'json',
				url: ajaxurl,
				data: {
					'action':  'save_seo_settings',
					'nonce':   pro_woo_filter_seo_settings.nonce,
					'data':    JSON.stringify( savedData ),
				},
				beforeSend : function() {
					if ( $('.pwf-save-seo-data').length > 0 ) {
						$('.pwf-save-seo-data').remove();
					}
					if ( $('.pwf-overlay').length > 0 ) {
						$('.pwf-overlay').removeClass('pwf-unactive').addClass('pwf-active');
					} else {
						$('body').prepend('<div class="pwf-overlay pwf-active"><span class="pwf-loader"></span></div>');
					}
				}
			}).done( function( result ) {
				let message = '<div class="notice pwf-save-seo-data notice-success is-dismissible"><p>' + result.message + '</p></div>';
				$('.pwf-error-message').append(message);
			}).fail( function(jqXHR, textStatus, errorThrown) {
				let message = '<div class="notice notice-error is-dismissible"><p>' + errorThrown + '</p></div>';
				$('.pwf-error-message').append(message);
			}).always( function() {
				$('.pwf-overlay').removeClass('pwf-active').addClass('pwf-unactive');
			});
		}
	};

	var translatedText = pro_woo_filter_seo_settings.translated_text;
	controllerEvents.init();
	
}(jQuery));